@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sentinel onboarding state
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Create Sentinel onboarding state
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sentinelOnboardingState = new AzureNative.SecurityInsights.SentinelOnboardingState("sentinelOnboardingState", new()
 *     {
 *         CustomerManagedKey = false,
 *         ResourceGroupName = "myRg",
 *         SentinelOnboardingStateName = "default",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewSentinelOnboardingState(ctx, "sentinelOnboardingState", &securityinsights.SentinelOnboardingStateArgs{
 * 			CustomerManagedKey:          pulumi.Bool(false),
 * 			ResourceGroupName:           pulumi.String("myRg"),
 * 			SentinelOnboardingStateName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.SentinelOnboardingState;
 * import com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sentinelOnboardingState = new SentinelOnboardingState("sentinelOnboardingState", SentinelOnboardingStateArgs.builder()
 *             .customerManagedKey(false)
 *             .resourceGroupName("myRg")
 *             .sentinelOnboardingStateName("default")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:SentinelOnboardingState default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/onboardingStates/{sentinelOnboardingStateName}
 * ```
 * @property customerManagedKey Flag that indicates the status of the CMK setting
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sentinelOnboardingStateName The Sentinel onboarding state name. Supports - default
 * @property workspaceName The name of the workspace.
 */
public data class SentinelOnboardingStateArgs(
    public val customerManagedKey: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sentinelOnboardingStateName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs =
        com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs.builder()
            .customerManagedKey(customerManagedKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sentinelOnboardingStateName(sentinelOnboardingStateName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SentinelOnboardingStateArgs].
 */
@PulumiTagMarker
public class SentinelOnboardingStateArgsBuilder internal constructor() {
    private var customerManagedKey: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var sentinelOnboardingStateName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Flag that indicates the status of the CMK setting
     */
    @JvmName("wnncaxqbuaaiwxya")
    public suspend fun customerManagedKey(`value`: Output<Boolean>) {
        this.customerManagedKey = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwruclctcsnbcmug")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Sentinel onboarding state name. Supports - default
     */
    @JvmName("lnwaegltyexjqeek")
    public suspend fun sentinelOnboardingStateName(`value`: Output<String>) {
        this.sentinelOnboardingStateName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("uadxjapojbpidijb")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Flag that indicates the status of the CMK setting
     */
    @JvmName("yxcdqmkgpioskvea")
    public suspend fun customerManagedKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKey = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("thupjbnnvghuwvpy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Sentinel onboarding state name. Supports - default
     */
    @JvmName("fsfnkcvufhblnnmx")
    public suspend fun sentinelOnboardingStateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sentinelOnboardingStateName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("cgqwxhmkycwmfkny")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SentinelOnboardingStateArgs = SentinelOnboardingStateArgs(
        customerManagedKey = customerManagedKey,
        resourceGroupName = resourceGroupName,
        sentinelOnboardingStateName = sentinelOnboardingStateName,
        workspaceName = workspaceName,
    )
}
