@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.DeploymentInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResourceInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.DeploymentInfoResponse.Companion.toKotlin as deploymentInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResourceInfoResponse.Companion.toKotlin as repositoryResourceInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.RepositoryResponse.Companion.toKotlin as repositoryResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SourceControl].
 */
@PulumiTagMarker
public class SourceControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SourceControlArgs = SourceControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SourceControlArgsBuilder.() -> Unit) {
        val builder = SourceControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SourceControl {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.SourceControl(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SourceControl(builtJavaResource)
    }
}

/**
 * Represents a SourceControl in Azure Security Insights.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview.
 * ## Example Usage
 * ### Creates a source control.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControl = new AzureNative.SecurityInsights.SourceControl("sourceControl", new()
 *     {
 *         ContentTypes = new[]
 *         {
 *             "AnalyticRules",
 *             "Workbook",
 *         },
 *         Description = "This is a source control",
 *         DisplayName = "My Source Control",
 *         RepoType = "Github",
 *         Repository = new AzureNative.SecurityInsights.Inputs.RepositoryArgs
 *         {
 *             Branch = "master",
 *             DisplayUrl = "https://github.com/user/repo",
 *             PathMapping = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ContentPathMapArgs
 *                 {
 *                     ContentType = "AnalyticRules",
 *                     Path = "path/to/rules",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.ContentPathMapArgs
 *                 {
 *                     ContentType = "Workbook",
 *                     Path = "path/to/workbooks",
 *                 },
 *             },
 *             Url = "https://github.com/user/repo",
 *         },
 *         ResourceGroupName = "myRg",
 *         SourceControlId = "789e0c1f-4a3d-43ad-809c-e713b677b04a",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewSourceControl(ctx, "sourceControl", &securityinsights.SourceControlArgs{
 * 			ContentTypes: pulumi.StringArray{
 * 				pulumi.String("AnalyticRules"),
 * 				pulumi.String("Workbook"),
 * 			},
 * 			Description: pulumi.String("This is a source control"),
 * 			DisplayName: pulumi.String("My Source Control"),
 * 			RepoType:    pulumi.String("Github"),
 * 			Repository: securityinsights.RepositoryResponse{
 * 				Branch:     pulumi.String("master"),
 * 				DisplayUrl: pulumi.String("https://github.com/user/repo"),
 * 				PathMapping: securityinsights.ContentPathMapArray{
 * 					&securityinsights.ContentPathMapArgs{
 * 						ContentType: pulumi.String("AnalyticRules"),
 * 						Path:        pulumi.String("path/to/rules"),
 * 					},
 * 					&securityinsights.ContentPathMapArgs{
 * 						ContentType: pulumi.String("Workbook"),
 * 						Path:        pulumi.String("path/to/workbooks"),
 * 					},
 * 				},
 * 				Url: pulumi.String("https://github.com/user/repo"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			SourceControlId:   pulumi.String("789e0c1f-4a3d-43ad-809c-e713b677b04a"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.SourceControl;
 * import com.pulumi.azurenative.securityinsights.SourceControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControl = new SourceControl("sourceControl", SourceControlArgs.builder()
 *             .contentTypes(
 *                 "AnalyticRules",
 *                 "Workbook")
 *             .description("This is a source control")
 *             .displayName("My Source Control")
 *             .repoType("Github")
 *             .repository(Map.ofEntries(
 *                 Map.entry("branch", "master"),
 *                 Map.entry("displayUrl", "https://github.com/user/repo"),
 *                 Map.entry("pathMapping",
 *                     Map.ofEntries(
 *                         Map.entry("contentType", "AnalyticRules"),
 *                         Map.entry("path", "path/to/rules")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("contentType", "Workbook"),
 *                         Map.entry("path", "path/to/workbooks")
 *                     )),
 *                 Map.entry("url", "https://github.com/user/repo")
 *             ))
 *             .resourceGroupName("myRg")
 *             .sourceControlId("789e0c1f-4a3d-43ad-809c-e713b677b04a")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:SourceControl 789e0c1f-4a3d-43ad-809c-e713b677b04a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/sourcecontrols/{sourceControlId}
 * ```
 */
public class SourceControl internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.SourceControl,
) : KotlinCustomResource(javaResource, SourceControlMapper) {
    /**
     * Array of source control content types.
     */
    public val contentTypes: Output<List<String>>
        get() = javaResource.contentTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A description of the source control
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the source control
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information regarding the latest deployment for the source control.
     */
    public val lastDeploymentInfo: Output<DeploymentInfoResponse>?
        get() = javaResource.lastDeploymentInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The repository type of the source control
     */
    public val repoType: Output<String>
        get() = javaResource.repoType().applyValue({ args0 -> args0 })

    /**
     * Repository metadata.
     */
    public val repository: Output<RepositoryResponse>
        get() = javaResource.repository().applyValue({ args0 ->
            args0.let({ args0 ->
                repositoryResponseToKotlin(args0)
            })
        })

    /**
     * Information regarding the resources created in user's repository.
     */
    public val repositoryResourceInfo: Output<RepositoryResourceInfoResponse>?
        get() = javaResource.repositoryResourceInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> repositoryResourceInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version number associated with the source control
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SourceControlMapper : ResourceMapper<SourceControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.SourceControl::class == javaResource::class

    override fun map(javaResource: Resource): SourceControl = SourceControl(
        javaResource as
            com.pulumi.azurenative.securityinsights.SourceControl,
    )
}

/**
 * @see [SourceControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SourceControl].
 */
public suspend fun sourceControl(
    name: String,
    block: suspend SourceControlResourceBuilder.() -> Unit,
): SourceControl {
    val builder = SourceControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SourceControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sourceControl(name: String): SourceControl {
    val builder = SourceControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
