@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceExternalReferenceArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceExternalReferenceArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceGranularMarkingModelArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceGranularMarkingModelArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceKillChainPhaseArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceKillChainPhaseArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceParsedPatternArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ThreatIntelligenceParsedPatternArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Threat intelligence information object.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2021-04-01, 2021-09-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Update a threat Intelligence indicator
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var threatIntelligenceIndicator = new AzureNative.SecurityInsights.ThreatIntelligenceIndicator("threatIntelligenceIndicator", new()
 *     {
 *         Confidence = 78,
 *         CreatedByRef = "contoso@contoso.com",
 *         Description = "debugging indicators",
 *         DisplayName = "new schema",
 *         ExternalReferences = new[] {},
 *         GranularMarkings = new[] {},
 *         KillChainPhases = new[] {},
 *         Kind = "indicator",
 *         Labels = new[] {},
 *         Modified = "",
 *         Name = "d9cd6f0b-96b9-3984-17cd-a779d1e15a93",
 *         Pattern = "[url:value = 'https://www.contoso.com']",
 *         PatternType = "url",
 *         ResourceGroupName = "myRg",
 *         Revoked = false,
 *         Source = "Azure Sentinel",
 *         ThreatIntelligenceTags = new[]
 *         {
 *             "new schema",
 *         },
 *         ThreatTypes = new[]
 *         {
 *             "compromised",
 *         },
 *         ValidFrom = "2020-04-15T17:44:00.114052Z",
 *         ValidUntil = "",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewThreatIntelligenceIndicator(ctx, "threatIntelligenceIndicator", &securityinsights.ThreatIntelligenceIndicatorArgs{
 * 			Confidence:         pulumi.Int(78),
 * 			CreatedByRef:       pulumi.String("contoso@contoso.com"),
 * 			Description:        pulumi.String("debugging indicators"),
 * 			DisplayName:        pulumi.String("new schema"),
 * 			ExternalReferences: securityinsights.ThreatIntelligenceExternalReferenceArray{},
 * 			GranularMarkings:   securityinsights.ThreatIntelligenceGranularMarkingModelArray{},
 * 			KillChainPhases:    securityinsights.ThreatIntelligenceKillChainPhaseArray{},
 * 			Kind:               pulumi.String("indicator"),
 * 			Labels:             pulumi.StringArray{},
 * 			Modified:           pulumi.String(""),
 * 			Name:               pulumi.String("d9cd6f0b-96b9-3984-17cd-a779d1e15a93"),
 * 			Pattern:            pulumi.String("[url:value = 'https://www.contoso.com']"),
 * 			PatternType:        pulumi.String("url"),
 * 			ResourceGroupName:  pulumi.String("myRg"),
 * 			Revoked:            pulumi.Bool(false),
 * 			Source:             pulumi.String("Azure Sentinel"),
 * 			ThreatIntelligenceTags: pulumi.StringArray{
 * 				pulumi.String("new schema"),
 * 			},
 * 			ThreatTypes: pulumi.StringArray{
 * 				pulumi.String("compromised"),
 * 			},
 * 			ValidFrom:     pulumi.String("2020-04-15T17:44:00.114052Z"),
 * 			ValidUntil:    pulumi.String(""),
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicator;
 * import com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var threatIntelligenceIndicator = new ThreatIntelligenceIndicator("threatIntelligenceIndicator", ThreatIntelligenceIndicatorArgs.builder()
 *             .confidence(78)
 *             .createdByRef("contoso@contoso.com")
 *             .description("debugging indicators")
 *             .displayName("new schema")
 *             .externalReferences()
 *             .granularMarkings()
 *             .killChainPhases()
 *             .kind("indicator")
 *             .labels()
 *             .modified("")
 *             .name("d9cd6f0b-96b9-3984-17cd-a779d1e15a93")
 *             .pattern("[url:value = 'https://www.contoso.com']")
 *             .patternType("url")
 *             .resourceGroupName("myRg")
 *             .revoked(false)
 *             .source("Azure Sentinel")
 *             .threatIntelligenceTags("new schema")
 *             .threatTypes("compromised")
 *             .validFrom("2020-04-15T17:44:00.114052Z")
 *             .validUntil("")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ThreatIntelligenceIndicator 180105c7-a28d-b1a2-4a78-234f6ec80fd6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/{name}
 * ```
 * @property confidence Confidence of threat intelligence entity
 * @property created Created by
 * @property createdByRef Created by reference of threat intelligence entity
 * @property defanged Is threat intelligence entity defanged
 * @property description Description of a threat intelligence entity
 * @property displayName Display name of a threat intelligence entity
 * @property extensions Extensions map
 * @property externalId External ID of threat intelligence entity
 * @property externalLastUpdatedTimeUtc External last updated time in UTC
 * @property externalReferences External References
 * @property granularMarkings Granular Markings
 * @property indicatorTypes Indicator types of threat intelligence entities
 * @property killChainPhases Kill chain phases
 * @property kind The kind of the threat intelligence entity
 * Expected value is 'indicator'.
 * @property labels Labels  of threat intelligence entity
 * @property language Language of threat intelligence entity
 * @property lastUpdatedTimeUtc Last updated time in UTC
 * @property modified Modified by
 * @property name Threat intelligence indicator name field.
 * @property objectMarkingRefs Threat intelligence entity object marking references
 * @property parsedPattern Parsed patterns
 * @property pattern Pattern of a threat intelligence entity
 * @property patternType Pattern type of a threat intelligence entity
 * @property patternVersion Pattern version of a threat intelligence entity
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revoked Is threat intelligence entity revoked
 * @property source Source of a threat intelligence entity
 * @property threatIntelligenceTags List of tags
 * @property threatTypes Threat types
 * @property validFrom Valid from
 * @property validUntil Valid until
 * @property workspaceName The name of the workspace.
 */
public data class ThreatIntelligenceIndicatorArgs(
    public val confidence: Output<Int>? = null,
    public val created: Output<String>? = null,
    public val createdByRef: Output<String>? = null,
    public val defanged: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val extensions: Output<Any>? = null,
    public val externalId: Output<String>? = null,
    public val externalLastUpdatedTimeUtc: Output<String>? = null,
    public val externalReferences: Output<List<ThreatIntelligenceExternalReferenceArgs>>? = null,
    public val granularMarkings: Output<List<ThreatIntelligenceGranularMarkingModelArgs>>? = null,
    public val indicatorTypes: Output<List<String>>? = null,
    public val killChainPhases: Output<List<ThreatIntelligenceKillChainPhaseArgs>>? = null,
    public val kind: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val language: Output<String>? = null,
    public val lastUpdatedTimeUtc: Output<String>? = null,
    public val modified: Output<String>? = null,
    public val name: Output<String>? = null,
    public val objectMarkingRefs: Output<List<String>>? = null,
    public val parsedPattern: Output<List<ThreatIntelligenceParsedPatternArgs>>? = null,
    public val pattern: Output<String>? = null,
    public val patternType: Output<String>? = null,
    public val patternVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revoked: Output<Boolean>? = null,
    public val source: Output<String>? = null,
    public val threatIntelligenceTags: Output<List<String>>? = null,
    public val threatTypes: Output<List<String>>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs =
        com.pulumi.azurenative.securityinsights.ThreatIntelligenceIndicatorArgs.builder()
            .confidence(confidence?.applyValue({ args0 -> args0 }))
            .created(created?.applyValue({ args0 -> args0 }))
            .createdByRef(createdByRef?.applyValue({ args0 -> args0 }))
            .defanged(defanged?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .extensions(extensions?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .externalLastUpdatedTimeUtc(externalLastUpdatedTimeUtc?.applyValue({ args0 -> args0 }))
            .externalReferences(
                externalReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .granularMarkings(
                granularMarkings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .indicatorTypes(indicatorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .killChainPhases(
                killChainPhases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .language(language?.applyValue({ args0 -> args0 }))
            .lastUpdatedTimeUtc(lastUpdatedTimeUtc?.applyValue({ args0 -> args0 }))
            .modified(modified?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .objectMarkingRefs(objectMarkingRefs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parsedPattern(
                parsedPattern?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pattern(pattern?.applyValue({ args0 -> args0 }))
            .patternType(patternType?.applyValue({ args0 -> args0 }))
            .patternVersion(patternVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revoked(revoked?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .threatIntelligenceTags(
                threatIntelligenceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .threatTypes(threatTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .validFrom(validFrom?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThreatIntelligenceIndicatorArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceIndicatorArgsBuilder internal constructor() {
    private var confidence: Output<Int>? = null

    private var created: Output<String>? = null

    private var createdByRef: Output<String>? = null

    private var defanged: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var extensions: Output<Any>? = null

    private var externalId: Output<String>? = null

    private var externalLastUpdatedTimeUtc: Output<String>? = null

    private var externalReferences: Output<List<ThreatIntelligenceExternalReferenceArgs>>? = null

    private var granularMarkings: Output<List<ThreatIntelligenceGranularMarkingModelArgs>>? = null

    private var indicatorTypes: Output<List<String>>? = null

    private var killChainPhases: Output<List<ThreatIntelligenceKillChainPhaseArgs>>? = null

    private var kind: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var language: Output<String>? = null

    private var lastUpdatedTimeUtc: Output<String>? = null

    private var modified: Output<String>? = null

    private var name: Output<String>? = null

    private var objectMarkingRefs: Output<List<String>>? = null

    private var parsedPattern: Output<List<ThreatIntelligenceParsedPatternArgs>>? = null

    private var pattern: Output<String>? = null

    private var patternType: Output<String>? = null

    private var patternVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revoked: Output<Boolean>? = null

    private var source: Output<String>? = null

    private var threatIntelligenceTags: Output<List<String>>? = null

    private var threatTypes: Output<List<String>>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Confidence of threat intelligence entity
     */
    @JvmName("wswqeqtivbftlmbm")
    public suspend fun confidence(`value`: Output<Int>) {
        this.confidence = value
    }

    /**
     * @param value Created by
     */
    @JvmName("icpglbvijtsepstj")
    public suspend fun created(`value`: Output<String>) {
        this.created = value
    }

    /**
     * @param value Created by reference of threat intelligence entity
     */
    @JvmName("smawxcaawrhwmxct")
    public suspend fun createdByRef(`value`: Output<String>) {
        this.createdByRef = value
    }

    /**
     * @param value Is threat intelligence entity defanged
     */
    @JvmName("rqytwtcnytdgmxdw")
    public suspend fun defanged(`value`: Output<Boolean>) {
        this.defanged = value
    }

    /**
     * @param value Description of a threat intelligence entity
     */
    @JvmName("lfkawtbytmhaerfg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of a threat intelligence entity
     */
    @JvmName("mhbhleuniohmdjwt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Extensions map
     */
    @JvmName("svkmbuigqeulsrmy")
    public suspend fun extensions(`value`: Output<Any>) {
        this.extensions = value
    }

    /**
     * @param value External ID of threat intelligence entity
     */
    @JvmName("xaxrwxreducrnlrt")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value External last updated time in UTC
     */
    @JvmName("gosgesjprlnyiige")
    public suspend fun externalLastUpdatedTimeUtc(`value`: Output<String>) {
        this.externalLastUpdatedTimeUtc = value
    }

    /**
     * @param value External References
     */
    @JvmName("lgjldnknfpaobdnc")
    public suspend
    fun externalReferences(`value`: Output<List<ThreatIntelligenceExternalReferenceArgs>>) {
        this.externalReferences = value
    }

    @JvmName("tpkelqlmbeprvwbv")
    public suspend fun externalReferences(
        vararg
        values: Output<ThreatIntelligenceExternalReferenceArgs>,
    ) {
        this.externalReferences = Output.all(values.asList())
    }

    /**
     * @param values External References
     */
    @JvmName("iasuavrforyedlwg")
    public suspend
    fun externalReferences(values: List<Output<ThreatIntelligenceExternalReferenceArgs>>) {
        this.externalReferences = Output.all(values)
    }

    /**
     * @param value Granular Markings
     */
    @JvmName("cyxormlgtbnhfwjb")
    public suspend
    fun granularMarkings(`value`: Output<List<ThreatIntelligenceGranularMarkingModelArgs>>) {
        this.granularMarkings = value
    }

    @JvmName("jhowsvkcyoxahtky")
    public suspend fun granularMarkings(
        vararg
        values: Output<ThreatIntelligenceGranularMarkingModelArgs>,
    ) {
        this.granularMarkings = Output.all(values.asList())
    }

    /**
     * @param values Granular Markings
     */
    @JvmName("pqiqvpntormfrpmu")
    public suspend
    fun granularMarkings(values: List<Output<ThreatIntelligenceGranularMarkingModelArgs>>) {
        this.granularMarkings = Output.all(values)
    }

    /**
     * @param value Indicator types of threat intelligence entities
     */
    @JvmName("vrnyupglilmjcyut")
    public suspend fun indicatorTypes(`value`: Output<List<String>>) {
        this.indicatorTypes = value
    }

    @JvmName("umimhgbifojshsnk")
    public suspend fun indicatorTypes(vararg values: Output<String>) {
        this.indicatorTypes = Output.all(values.asList())
    }

    /**
     * @param values Indicator types of threat intelligence entities
     */
    @JvmName("fjydkjsvmvyfjcyq")
    public suspend fun indicatorTypes(values: List<Output<String>>) {
        this.indicatorTypes = Output.all(values)
    }

    /**
     * @param value Kill chain phases
     */
    @JvmName("ilsmpqndjeikbkwp")
    public suspend fun killChainPhases(`value`: Output<List<ThreatIntelligenceKillChainPhaseArgs>>) {
        this.killChainPhases = value
    }

    @JvmName("aqvimqfkojghojek")
    public suspend fun killChainPhases(vararg values: Output<ThreatIntelligenceKillChainPhaseArgs>) {
        this.killChainPhases = Output.all(values.asList())
    }

    /**
     * @param values Kill chain phases
     */
    @JvmName("vnjuihhrrmtmfcbn")
    public suspend fun killChainPhases(values: List<Output<ThreatIntelligenceKillChainPhaseArgs>>) {
        this.killChainPhases = Output.all(values)
    }

    /**
     * @param value The kind of the threat intelligence entity
     * Expected value is 'indicator'.
     */
    @JvmName("imwxjtqxnypivyiq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Labels  of threat intelligence entity
     */
    @JvmName("fblsydeevahlgsbd")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("douhjeiqmqogevba")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values Labels  of threat intelligence entity
     */
    @JvmName("tddcwpfgeodqfgdq")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Language of threat intelligence entity
     */
    @JvmName("biqjbtjwimqobryv")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value Last updated time in UTC
     */
    @JvmName("bschjghhlysqalnh")
    public suspend fun lastUpdatedTimeUtc(`value`: Output<String>) {
        this.lastUpdatedTimeUtc = value
    }

    /**
     * @param value Modified by
     */
    @JvmName("efhcaevebbuvycfo")
    public suspend fun modified(`value`: Output<String>) {
        this.modified = value
    }

    /**
     * @param value Threat intelligence indicator name field.
     */
    @JvmName("ccrmbnknoochvjhj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Threat intelligence entity object marking references
     */
    @JvmName("dkpbeanijxdomxqx")
    public suspend fun objectMarkingRefs(`value`: Output<List<String>>) {
        this.objectMarkingRefs = value
    }

    @JvmName("cdmbjidyutkijflu")
    public suspend fun objectMarkingRefs(vararg values: Output<String>) {
        this.objectMarkingRefs = Output.all(values.asList())
    }

    /**
     * @param values Threat intelligence entity object marking references
     */
    @JvmName("matarpeyouqodepa")
    public suspend fun objectMarkingRefs(values: List<Output<String>>) {
        this.objectMarkingRefs = Output.all(values)
    }

    /**
     * @param value Parsed patterns
     */
    @JvmName("fiukogaxsugkaoku")
    public suspend fun parsedPattern(`value`: Output<List<ThreatIntelligenceParsedPatternArgs>>) {
        this.parsedPattern = value
    }

    @JvmName("bkxukggdjqlifsyb")
    public suspend fun parsedPattern(vararg values: Output<ThreatIntelligenceParsedPatternArgs>) {
        this.parsedPattern = Output.all(values.asList())
    }

    /**
     * @param values Parsed patterns
     */
    @JvmName("yfnhtscevycrwvwg")
    public suspend fun parsedPattern(values: List<Output<ThreatIntelligenceParsedPatternArgs>>) {
        this.parsedPattern = Output.all(values)
    }

    /**
     * @param value Pattern of a threat intelligence entity
     */
    @JvmName("hnevrqbkvpbtbcub")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value Pattern type of a threat intelligence entity
     */
    @JvmName("qcrnmdejcnxqodno")
    public suspend fun patternType(`value`: Output<String>) {
        this.patternType = value
    }

    /**
     * @param value Pattern version of a threat intelligence entity
     */
    @JvmName("otvmdbwldowjwlnr")
    public suspend fun patternVersion(`value`: Output<String>) {
        this.patternVersion = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qgdxyvqdxgaayesn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Is threat intelligence entity revoked
     */
    @JvmName("sbknggcpdnrrmwel")
    public suspend fun revoked(`value`: Output<Boolean>) {
        this.revoked = value
    }

    /**
     * @param value Source of a threat intelligence entity
     */
    @JvmName("njjcudsjembdpjgb")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value List of tags
     */
    @JvmName("mwkmixrxahomtpdt")
    public suspend fun threatIntelligenceTags(`value`: Output<List<String>>) {
        this.threatIntelligenceTags = value
    }

    @JvmName("orlnwoffrapxqqqi")
    public suspend fun threatIntelligenceTags(vararg values: Output<String>) {
        this.threatIntelligenceTags = Output.all(values.asList())
    }

    /**
     * @param values List of tags
     */
    @JvmName("hmpirgqxhitasfrq")
    public suspend fun threatIntelligenceTags(values: List<Output<String>>) {
        this.threatIntelligenceTags = Output.all(values)
    }

    /**
     * @param value Threat types
     */
    @JvmName("rmetcwpuyrsimtxm")
    public suspend fun threatTypes(`value`: Output<List<String>>) {
        this.threatTypes = value
    }

    @JvmName("xqhcusoldayabcwt")
    public suspend fun threatTypes(vararg values: Output<String>) {
        this.threatTypes = Output.all(values.asList())
    }

    /**
     * @param values Threat types
     */
    @JvmName("hancsfdleyebwxfh")
    public suspend fun threatTypes(values: List<Output<String>>) {
        this.threatTypes = Output.all(values)
    }

    /**
     * @param value Valid from
     */
    @JvmName("iqmkxfdcbnrbtuci")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value Valid until
     */
    @JvmName("uobmmayneuyfupuq")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("qyduprijnoyftdgr")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Confidence of threat intelligence entity
     */
    @JvmName("ytltwnbmmusogdea")
    public suspend fun confidence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidence = mapped
    }

    /**
     * @param value Created by
     */
    @JvmName("yhebvcfxbknklsig")
    public suspend fun created(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.created = mapped
    }

    /**
     * @param value Created by reference of threat intelligence entity
     */
    @JvmName("ghodxnxirvrmjkdu")
    public suspend fun createdByRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdByRef = mapped
    }

    /**
     * @param value Is threat intelligence entity defanged
     */
    @JvmName("idwknxqyjexgoibg")
    public suspend fun defanged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defanged = mapped
    }

    /**
     * @param value Description of a threat intelligence entity
     */
    @JvmName("xdrjbmtaasmwywof")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of a threat intelligence entity
     */
    @JvmName("lpcetkekxddlxhup")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Extensions map
     */
    @JvmName("qrkddplxwusitjmw")
    public suspend fun extensions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value External ID of threat intelligence entity
     */
    @JvmName("xersunpwvioujplf")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value External last updated time in UTC
     */
    @JvmName("wvaxfaiteikvopcd")
    public suspend fun externalLastUpdatedTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalLastUpdatedTimeUtc = mapped
    }

    /**
     * @param value External References
     */
    @JvmName("yqnuesikbotuxqxc")
    public suspend fun externalReferences(`value`: List<ThreatIntelligenceExternalReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalReferences = mapped
    }

    /**
     * @param argument External References
     */
    @JvmName("vojcnktusrgmelwf")
    public suspend
    fun externalReferences(argument: List<suspend ThreatIntelligenceExternalReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceExternalReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.externalReferences = mapped
    }

    /**
     * @param argument External References
     */
    @JvmName("fbuuiqjnovktmrne")
    public suspend fun externalReferences(
        vararg
        argument: suspend ThreatIntelligenceExternalReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceExternalReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.externalReferences = mapped
    }

    /**
     * @param argument External References
     */
    @JvmName("mrmaxpvrmtumenju")
    public suspend
    fun externalReferences(argument: suspend ThreatIntelligenceExternalReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThreatIntelligenceExternalReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.externalReferences = mapped
    }

    /**
     * @param values External References
     */
    @JvmName("dswkttufdlxbdgpc")
    public suspend fun externalReferences(vararg values: ThreatIntelligenceExternalReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalReferences = mapped
    }

    /**
     * @param value Granular Markings
     */
    @JvmName("mrvnkabriihdsygt")
    public suspend fun granularMarkings(`value`: List<ThreatIntelligenceGranularMarkingModelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granularMarkings = mapped
    }

    /**
     * @param argument Granular Markings
     */
    @JvmName("lhckqoperyacwhdr")
    public suspend
    fun granularMarkings(argument: List<suspend ThreatIntelligenceGranularMarkingModelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceGranularMarkingModelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.granularMarkings = mapped
    }

    /**
     * @param argument Granular Markings
     */
    @JvmName("okacwdedqkidawtc")
    public suspend fun granularMarkings(
        vararg
        argument: suspend ThreatIntelligenceGranularMarkingModelArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceGranularMarkingModelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.granularMarkings = mapped
    }

    /**
     * @param argument Granular Markings
     */
    @JvmName("haduouotbmkivjyr")
    public suspend
    fun granularMarkings(argument: suspend ThreatIntelligenceGranularMarkingModelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThreatIntelligenceGranularMarkingModelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.granularMarkings = mapped
    }

    /**
     * @param values Granular Markings
     */
    @JvmName("wtlrpxexcmygkheq")
    public suspend fun granularMarkings(vararg values: ThreatIntelligenceGranularMarkingModelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularMarkings = mapped
    }

    /**
     * @param value Indicator types of threat intelligence entities
     */
    @JvmName("clgfhebmxvhfmlke")
    public suspend fun indicatorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indicatorTypes = mapped
    }

    /**
     * @param values Indicator types of threat intelligence entities
     */
    @JvmName("uynyskvwjrrqaxgg")
    public suspend fun indicatorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indicatorTypes = mapped
    }

    /**
     * @param value Kill chain phases
     */
    @JvmName("enkgjlprfxjletgi")
    public suspend fun killChainPhases(`value`: List<ThreatIntelligenceKillChainPhaseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.killChainPhases = mapped
    }

    /**
     * @param argument Kill chain phases
     */
    @JvmName("tucjakfauwcthcbl")
    public suspend
    fun killChainPhases(argument: List<suspend ThreatIntelligenceKillChainPhaseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceKillChainPhaseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.killChainPhases = mapped
    }

    /**
     * @param argument Kill chain phases
     */
    @JvmName("jlqfgocrvdcmmffu")
    public suspend fun killChainPhases(
        vararg
        argument: suspend ThreatIntelligenceKillChainPhaseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceKillChainPhaseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.killChainPhases = mapped
    }

    /**
     * @param argument Kill chain phases
     */
    @JvmName("ajyccufeorxhxdwh")
    public suspend
    fun killChainPhases(argument: suspend ThreatIntelligenceKillChainPhaseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThreatIntelligenceKillChainPhaseArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.killChainPhases = mapped
    }

    /**
     * @param values Kill chain phases
     */
    @JvmName("xlqcjykinjmgoefy")
    public suspend fun killChainPhases(vararg values: ThreatIntelligenceKillChainPhaseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.killChainPhases = mapped
    }

    /**
     * @param value The kind of the threat intelligence entity
     * Expected value is 'indicator'.
     */
    @JvmName("hmaietftpyumbnqw")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Labels  of threat intelligence entity
     */
    @JvmName("rffgobsrahnwvsql")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Labels  of threat intelligence entity
     */
    @JvmName("xhtfnrhikhwyakys")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Language of threat intelligence entity
     */
    @JvmName("bqsbiirivcbbovfk")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value Last updated time in UTC
     */
    @JvmName("vpqgeuhrbavdvqii")
    public suspend fun lastUpdatedTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTimeUtc = mapped
    }

    /**
     * @param value Modified by
     */
    @JvmName("ttlfqvhglfpdplhn")
    public suspend fun modified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modified = mapped
    }

    /**
     * @param value Threat intelligence indicator name field.
     */
    @JvmName("otjsdgibyvefpjmj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Threat intelligence entity object marking references
     */
    @JvmName("bcxpqrjooyjjirbv")
    public suspend fun objectMarkingRefs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectMarkingRefs = mapped
    }

    /**
     * @param values Threat intelligence entity object marking references
     */
    @JvmName("atkjsagkjridssru")
    public suspend fun objectMarkingRefs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectMarkingRefs = mapped
    }

    /**
     * @param value Parsed patterns
     */
    @JvmName("foksrqjyyxyvwhqp")
    public suspend fun parsedPattern(`value`: List<ThreatIntelligenceParsedPatternArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parsedPattern = mapped
    }

    /**
     * @param argument Parsed patterns
     */
    @JvmName("gregoaawvpraseai")
    public suspend
    fun parsedPattern(argument: List<suspend ThreatIntelligenceParsedPatternArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceParsedPatternArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parsedPattern = mapped
    }

    /**
     * @param argument Parsed patterns
     */
    @JvmName("aqtbojevdfvpwtur")
    public suspend fun parsedPattern(
        vararg
        argument: suspend ThreatIntelligenceParsedPatternArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceParsedPatternArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parsedPattern = mapped
    }

    /**
     * @param argument Parsed patterns
     */
    @JvmName("drrxbucjrrgcqwoa")
    public suspend
    fun parsedPattern(argument: suspend ThreatIntelligenceParsedPatternArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThreatIntelligenceParsedPatternArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parsedPattern = mapped
    }

    /**
     * @param values Parsed patterns
     */
    @JvmName("xmpdcvnjphvjfick")
    public suspend fun parsedPattern(vararg values: ThreatIntelligenceParsedPatternArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parsedPattern = mapped
    }

    /**
     * @param value Pattern of a threat intelligence entity
     */
    @JvmName("pyfchlxfvpucuiid")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param value Pattern type of a threat intelligence entity
     */
    @JvmName("aybkoodsfbigedpx")
    public suspend fun patternType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternType = mapped
    }

    /**
     * @param value Pattern version of a threat intelligence entity
     */
    @JvmName("qryikhokaxbrqxli")
    public suspend fun patternVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternVersion = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqiuidchpovdqgkp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Is threat intelligence entity revoked
     */
    @JvmName("schorxaripfgjkfa")
    public suspend fun revoked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revoked = mapped
    }

    /**
     * @param value Source of a threat intelligence entity
     */
    @JvmName("ykqotvaixptchqfc")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value List of tags
     */
    @JvmName("ltnmqsnfsajvcftq")
    public suspend fun threatIntelligenceTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelligenceTags = mapped
    }

    /**
     * @param values List of tags
     */
    @JvmName("atllpegkjymmeimc")
    public suspend fun threatIntelligenceTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelligenceTags = mapped
    }

    /**
     * @param value Threat types
     */
    @JvmName("mycmwxmuyqsoqhpv")
    public suspend fun threatTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatTypes = mapped
    }

    /**
     * @param values Threat types
     */
    @JvmName("vfisofllmscukmvn")
    public suspend fun threatTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatTypes = mapped
    }

    /**
     * @param value Valid from
     */
    @JvmName("ameuqekyhyoeibys")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value Valid until
     */
    @JvmName("boxmsfosuqnuprjm")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wcphpgsfxqiugcuy")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ThreatIntelligenceIndicatorArgs = ThreatIntelligenceIndicatorArgs(
        confidence = confidence,
        created = created,
        createdByRef = createdByRef,
        defanged = defanged,
        description = description,
        displayName = displayName,
        extensions = extensions,
        externalId = externalId,
        externalLastUpdatedTimeUtc = externalLastUpdatedTimeUtc,
        externalReferences = externalReferences,
        granularMarkings = granularMarkings,
        indicatorTypes = indicatorTypes,
        killChainPhases = killChainPhases,
        kind = kind,
        labels = labels,
        language = language,
        lastUpdatedTimeUtc = lastUpdatedTimeUtc,
        modified = modified,
        name = name,
        objectMarkingRefs = objectMarkingRefs,
        parsedPattern = parsedPattern,
        pattern = pattern,
        patternType = patternType,
        patternVersion = patternVersion,
        resourceGroupName = resourceGroupName,
        revoked = revoked,
        source = source,
        threatIntelligenceTags = threatIntelligenceTags,
        threatTypes = threatTypes,
        validFrom = validFrom,
        validUntil = validUntil,
        workspaceName = workspaceName,
    )
}
