@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.AssignmentItemResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AssignmentItemResponse.Companion.toKotlin as assignmentItemResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WorkspaceManagerAssignment].
 */
@PulumiTagMarker
public class WorkspaceManagerAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceManagerAssignmentArgs = WorkspaceManagerAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceManagerAssignmentArgsBuilder.() -> Unit) {
        val builder = WorkspaceManagerAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceManagerAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceManagerAssignment(builtJavaResource)
    }
}

/**
 * The workspace manager assignment
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Creates or updates a workspace manager assignment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerAssignment = new AzureNative.SecurityInsights.WorkspaceManagerAssignment("workspaceManagerAssignment", new()
 *     {
 *         Items = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.AssignmentItemArgs
 *             {
 *                 ResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne",
 *             },
 *             new AzureNative.SecurityInsights.Inputs.AssignmentItemArgs
 *             {
 *                 ResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         TargetResourceName = "37207a7a-3b8a-438f-a559-c7df400e1b96",
 *         WorkspaceManagerAssignmentName = "47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerAssignment(ctx, "workspaceManagerAssignment", &securityinsights.WorkspaceManagerAssignmentArgs{
 * 			Items: []securityinsights.AssignmentItemArgs{
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne"),
 * 				},
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo"),
 * 				},
 * 			},
 * 			ResourceGroupName:              pulumi.String("myRg"),
 * 			TargetResourceName:             pulumi.String("37207a7a-3b8a-438f-a559-c7df400e1b96"),
 * 			WorkspaceManagerAssignmentName: pulumi.String("47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58"),
 * 			WorkspaceName:                  pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerAssignment = new WorkspaceManagerAssignment("workspaceManagerAssignment", WorkspaceManagerAssignmentArgs.builder()
 *             .items(
 *                 Map.of("resourceId", "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne"),
 *                 Map.of("resourceId", "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo"))
 *             .resourceGroupName("myRg")
 *             .targetResourceName("37207a7a-3b8a-438f-a559-c7df400e1b96")
 *             .workspaceManagerAssignmentName("47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerAssignment 47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}
 * ```
 */
public class WorkspaceManagerAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment,
) : KotlinCustomResource(javaResource, WorkspaceManagerAssignmentMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of resources included in this workspace manager assignment
     */
    public val items: Output<List<AssignmentItemResponse>>
        get() = javaResource.items().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assignmentItemResponseToKotlin(args0)
                })
            })
        })

    /**
     * The time the last job associated to this assignment ended at
     */
    public val lastJobEndTime: Output<String>
        get() = javaResource.lastJobEndTime().applyValue({ args0 -> args0 })

    /**
     * State of the last job associated to this assignment
     */
    public val lastJobProvisioningState: Output<String>
        get() = javaResource.lastJobProvisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource name of the workspace manager group targeted by the workspace manager assignment
     */
    public val targetResourceName: Output<String>
        get() = javaResource.targetResourceName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceManagerAssignmentMapper : ResourceMapper<WorkspaceManagerAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceManagerAssignment =
        WorkspaceManagerAssignment(
            javaResource as
                com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment,
        )
}

/**
 * @see [WorkspaceManagerAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceManagerAssignment].
 */
public suspend fun workspaceManagerAssignment(
    name: String,
    block: suspend WorkspaceManagerAssignmentResourceBuilder.() -> Unit,
):
    WorkspaceManagerAssignment {
    val builder = WorkspaceManagerAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceManagerAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceManagerAssignment(name: String): WorkspaceManagerAssignment {
    val builder = WorkspaceManagerAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
