@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WorkspaceManagerGroup].
 */
@PulumiTagMarker
public class WorkspaceManagerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceManagerGroupArgs = WorkspaceManagerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceManagerGroupArgsBuilder.() -> Unit) {
        val builder = WorkspaceManagerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceManagerGroup {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceManagerGroup(builtJavaResource)
    }
}

/**
 * The workspace manager group
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Creates or updates a workspace manager group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerGroup = new AzureNative.SecurityInsights.WorkspaceManagerGroup("workspaceManagerGroup", new()
 *     {
 *         Description = "Group of all financial and banking institutions",
 *         DisplayName = "Banks",
 *         MemberResourceNames = new[]
 *         {
 *             "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *             "f5fa104e-c0e3-4747-9182-d342dc048a9e",
 *         },
 *         ResourceGroupName = "myRg",
 *         WorkspaceManagerGroupName = "37207a7a-3b8a-438f-a559-c7df400e1b96",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerGroup(ctx, "workspaceManagerGroup", &securityinsights.WorkspaceManagerGroupArgs{
 * 			Description: pulumi.String("Group of all financial and banking institutions"),
 * 			DisplayName: pulumi.String("Banks"),
 * 			MemberResourceNames: pulumi.StringArray{
 * 				pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 				pulumi.String("f5fa104e-c0e3-4747-9182-d342dc048a9e"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("myRg"),
 * 			WorkspaceManagerGroupName: pulumi.String("37207a7a-3b8a-438f-a559-c7df400e1b96"),
 * 			WorkspaceName:             pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerGroup = new WorkspaceManagerGroup("workspaceManagerGroup", WorkspaceManagerGroupArgs.builder()
 *             .description("Group of all financial and banking institutions")
 *             .displayName("Banks")
 *             .memberResourceNames(
 *                 "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *                 "f5fa104e-c0e3-4747-9182-d342dc048a9e")
 *             .resourceGroupName("myRg")
 *             .workspaceManagerGroupName("37207a7a-3b8a-438f-a559-c7df400e1b96")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerGroup 37207a7a-3b8a-438f-a559-c7df400e1b96 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}
 * ```
 */
public class WorkspaceManagerGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup,
) : KotlinCustomResource(javaResource, WorkspaceManagerGroupMapper) {
    /**
     * The description of the workspace manager group
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the workspace manager group
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The names of the workspace manager members participating in this group.
     */
    public val memberResourceNames: Output<List<String>>
        get() = javaResource.memberResourceNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceManagerGroupMapper : ResourceMapper<WorkspaceManagerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceManagerGroup =
        WorkspaceManagerGroup(
            javaResource as
                com.pulumi.azurenative.securityinsights.WorkspaceManagerGroup,
        )
}

/**
 * @see [WorkspaceManagerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceManagerGroup].
 */
public suspend fun workspaceManagerGroup(
    name: String,
    block: suspend WorkspaceManagerGroupResourceBuilder.() -> Unit,
): WorkspaceManagerGroup {
    val builder = WorkspaceManagerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceManagerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceManagerGroup(name: String): WorkspaceManagerGroup {
    val builder = WorkspaceManagerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
