@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class AutomationRulePropertyConditionSupportedOperator(
    public val javaValue:
    com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator> {
    /**
     * Evaluates if the property equals at least one of the condition values
     */
    Equals(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.Equals),

    /**
     * Evaluates if the property does not equal any of the condition values
     */
    NotEquals(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.NotEquals),

    /**
     * Evaluates if the property contains at least one of the condition values
     */
    Contains(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.Contains),

    /**
     * Evaluates if the property does not contain any of the condition values
     */
    NotContains(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.NotContains),

    /**
     * Evaluates if the property starts with any of the condition values
     */
    StartsWith(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.StartsWith),

    /**
     * Evaluates if the property does not start with any of the condition values
     */
    NotStartsWith(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.NotStartsWith),

    /**
     * Evaluates if the property ends with any of the condition values
     */
    EndsWith(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.EndsWith),

    /**
     * Evaluates if the property does not end with any of the condition values
     */
    NotEndsWith(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator.NotEndsWith),
    ;

    override fun toJava():
        com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedOperator):
            AutomationRulePropertyConditionSupportedOperator =
            AutomationRulePropertyConditionSupportedOperator.values().first { it.javaValue == javaType }
    }
}
