@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes how to ingest the records in the file.
 */
public enum class IngestionMode(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.IngestionMode,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.IngestionMode> {
    /**
     * No records should be ingested when invalid records are detected.
     */
    IngestOnlyIfAllAreValid(com.pulumi.azurenative.securityinsights.enums.IngestionMode.IngestOnlyIfAllAreValid),

    /**
     * Valid records should still be ingested when invalid records are detected.
     */
    IngestAnyValidRecords(com.pulumi.azurenative.securityinsights.enums.IngestionMode.IngestAnyValidRecords),

    /**
     * Unspecified
     */
    Unspecified(com.pulumi.azurenative.securityinsights.enums.IngestionMode.Unspecified),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.IngestionMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.IngestionMode):
            IngestionMode = IngestionMode.values().first { it.javaValue == javaType }
    }
}
