@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesConditionArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyConditionSupportedOperator
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyConditionSupportedProperty
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property operator
 * @property propertyName The property to evaluate in an automation rule property condition.
 * @property propertyValues
 */
public data class AutomationRulePropertyValuesConditionArgs(
    public val `operator`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>? =
        null,
    public val propertyName: Output<Either<String, AutomationRulePropertyConditionSupportedProperty>>? =
        null,
    public val propertyValues: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesConditionArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyValuesConditionArgs.builder()
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyName(
                propertyName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyValues(propertyValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AutomationRulePropertyValuesConditionArgs].
 */
@PulumiTagMarker
public class AutomationRulePropertyValuesConditionArgsBuilder internal constructor() {
    private var `operator`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>? =
        null

    private var propertyName:
        Output<Either<String, AutomationRulePropertyConditionSupportedProperty>>? = null

    private var propertyValues: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("stdmjkabhorkevcl")
    public suspend
    fun `operator`(`value`: Output<Either<String, AutomationRulePropertyConditionSupportedOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value The property to evaluate in an automation rule property condition.
     */
    @JvmName("warfeygrmngqhlip")
    public suspend
    fun propertyName(`value`: Output<Either<String, AutomationRulePropertyConditionSupportedProperty>>) {
        this.propertyName = value
    }

    /**
     * @param value
     */
    @JvmName("ewmdnejeioyogsnb")
    public suspend fun propertyValues(`value`: Output<List<String>>) {
        this.propertyValues = value
    }

    @JvmName("abdtgsghxyxyjskn")
    public suspend fun propertyValues(vararg values: Output<String>) {
        this.propertyValues = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pkovhpjxpjmnjuvh")
    public suspend fun propertyValues(values: List<Output<String>>) {
        this.propertyValues = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("toenowyqltexiuic")
    public suspend
    fun `operator`(`value`: Either<String, AutomationRulePropertyConditionSupportedOperator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value
     */
    @JvmName("iyrhtrhpsulbbfsc")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutomationRulePropertyConditionSupportedOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value
     */
    @JvmName("utejgfmbpljfmqqg")
    public fun `operator`(`value`: AutomationRulePropertyConditionSupportedOperator) {
        val toBeMapped = Either.ofRight<String, AutomationRulePropertyConditionSupportedOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The property to evaluate in an automation rule property condition.
     */
    @JvmName("rwrushkvfjbwiwxt")
    public suspend
    fun propertyName(`value`: Either<String, AutomationRulePropertyConditionSupportedProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value The property to evaluate in an automation rule property condition.
     */
    @JvmName("jqvmidvphtigpwcx")
    public fun propertyName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutomationRulePropertyConditionSupportedProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value The property to evaluate in an automation rule property condition.
     */
    @JvmName("pxhvvrmfnigpmsvj")
    public fun propertyName(`value`: AutomationRulePropertyConditionSupportedProperty) {
        val toBeMapped = Either.ofRight<String, AutomationRulePropertyConditionSupportedProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("egymqrtaqvuyvoeh")
    public suspend fun propertyValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    /**
     * @param values
     */
    @JvmName("pftwvfgqwuocximb")
    public suspend fun propertyValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    internal fun build(): AutomationRulePropertyValuesConditionArgs =
        AutomationRulePropertyValuesConditionArgs(
            `operator` = `operator`,
            propertyName = propertyName,
            propertyValues = propertyValues,
        )
}
