@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ConnectivityCriterionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The criteria by which we determine whether the connector is connected or not.
 * For Example, use a KQL query to check if  the expected data type is flowing).
 * @property type Gets or sets the type of connectivity.
 * @property value Gets or sets the queries for checking connectivity.
 */
public data class ConnectivityCriterionArgs(
    public val type: Output<String>,
    public val `value`: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ConnectivityCriterionArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ConnectivityCriterionArgs =
        com.pulumi.azurenative.securityinsights.inputs.ConnectivityCriterionArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConnectivityCriterionArgs].
 */
@PulumiTagMarker
public class ConnectivityCriterionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<List<String>>? = null

    /**
     * @param value Gets or sets the type of connectivity.
     */
    @JvmName("bvqiabwgmleuqugx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the queries for checking connectivity.
     */
    @JvmName("tcoghbyimjaqhdli")
    public suspend fun `value`(`value`: Output<List<String>>) {
        this.`value` = value
    }

    @JvmName("psxyrlntowbcjbqk")
    public suspend fun `value`(vararg values: Output<String>) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the queries for checking connectivity.
     */
    @JvmName("rwslwprgbsppkxax")
    public suspend fun `value`(values: List<Output<String>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value Gets or sets the type of connectivity.
     */
    @JvmName("ftdqjvexnxakekre")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the queries for checking connectivity.
     */
    @JvmName("pmktkkjxkxxyayhs")
    public suspend fun `value`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param values Gets or sets the queries for checking connectivity.
     */
    @JvmName("jvpkvwrolgvmsevq")
    public suspend fun `value`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConnectivityCriterionArgs = ConnectivityCriterionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value`,
    )
}
