@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ConnectorDataTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data type which is created by the connector,
 * including a query indicated when was the last time that data type was received in the workspace.
 * @property lastDataReceivedQuery Gets or sets the query to indicate when relevant data was last received in the workspace.
 * @property name Gets or sets the name of the data type to show in the graph.
 */
public data class ConnectorDataTypeArgs(
    public val lastDataReceivedQuery: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ConnectorDataTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ConnectorDataTypeArgs =
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDataTypeArgs.builder()
            .lastDataReceivedQuery(lastDataReceivedQuery.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorDataTypeArgs].
 */
@PulumiTagMarker
public class ConnectorDataTypeArgsBuilder internal constructor() {
    private var lastDataReceivedQuery: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the query to indicate when relevant data was last received in the workspace.
     */
    @JvmName("qkcwdhnyyjmhvdej")
    public suspend fun lastDataReceivedQuery(`value`: Output<String>) {
        this.lastDataReceivedQuery = value
    }

    /**
     * @param value Gets or sets the name of the data type to show in the graph.
     */
    @JvmName("rcnwwtnahoviwxap")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the query to indicate when relevant data was last received in the workspace.
     */
    @JvmName("liicsgcyxaiolaxl")
    public suspend fun lastDataReceivedQuery(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastDataReceivedQuery = mapped
    }

    /**
     * @param value Gets or sets the name of the data type to show in the graph.
     */
    @JvmName("uotnracctnodbjlo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ConnectorDataTypeArgs = ConnectorDataTypeArgs(
        lastDataReceivedQuery = lastDataReceivedQuery ?: throw
            PulumiNullFieldException("lastDataReceivedQuery"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
