@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetContentTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property templateId template Id
 * @property workspaceName The name of the workspace.
 */
public data class GetContentTemplatePlainArgs(
    public val resourceGroupName: String,
    public val templateId: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetContentTemplatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetContentTemplatePlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetContentTemplatePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .templateId(templateId.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContentTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetContentTemplatePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var templateId: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yrjnnsprmskcqtjm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value template Id
     */
    @JvmName("kipoxxbmekuyaqwv")
    public suspend fun templateId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("srgsrviqfchyeagx")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetContentTemplatePlainArgs = GetContentTemplatePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        templateId = templateId ?: throw PulumiNullFieldException("templateId"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
