@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetCustomizableConnectorDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataConnectorDefinitionName The data connector definition name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetCustomizableConnectorDefinitionPlainArgs(
    public val dataConnectorDefinitionName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetCustomizableConnectorDefinitionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetCustomizableConnectorDefinitionPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetCustomizableConnectorDefinitionPlainArgs.builder()
            .dataConnectorDefinitionName(dataConnectorDefinitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomizableConnectorDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetCustomizableConnectorDefinitionPlainArgsBuilder internal constructor() {
    private var dataConnectorDefinitionName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The data connector definition name.
     */
    @JvmName("xblxjdxiobucttbv")
    public suspend fun dataConnectorDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataConnectorDefinitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("logwlwildrgftnlx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kdrnnasaaknkmxbr")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetCustomizableConnectorDefinitionPlainArgs =
        GetCustomizableConnectorDefinitionPlainArgs(
            dataConnectorDefinitionName = dataConnectorDefinitionName ?: throw
                PulumiNullFieldException("dataConnectorDefinitionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
