@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetWatchlistPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property watchlistAlias The watchlist alias
 * @property workspaceName The name of the workspace.
 */
public data class GetWatchlistPlainArgs(
    public val resourceGroupName: String,
    public val watchlistAlias: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetWatchlistPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetWatchlistPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetWatchlistPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .watchlistAlias(watchlistAlias.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWatchlistPlainArgs].
 */
@PulumiTagMarker
public class GetWatchlistPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var watchlistAlias: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmwkhebmivgsauil")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The watchlist alias
     */
    @JvmName("lrmhqusghowdjrgu")
    public suspend fun watchlistAlias(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.watchlistAlias = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("rfshtwdmbigdbpsj")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWatchlistPlainArgs = GetWatchlistPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        watchlistAlias = watchlistAlias ?: throw PulumiNullFieldException("watchlistAlias"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
