@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerAssignmentName The name of the workspace manager assignment
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceManagerAssignmentPlainArgs(
    public val resourceGroupName: String,
    public val workspaceManagerAssignmentName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerAssignmentPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerAssignmentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceManagerAssignmentName(workspaceManagerAssignmentName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceManagerAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceManagerAssignmentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceManagerAssignmentName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("roseyydpdcophrju")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager assignment
     */
    @JvmName("qudsosurpxnltdvx")
    public suspend fun workspaceManagerAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceManagerAssignmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dldrrfllswfebjoe")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceManagerAssignmentPlainArgs =
        GetWorkspaceManagerAssignmentPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceManagerAssignmentName = workspaceManagerAssignmentName ?: throw
                PulumiNullFieldException("workspaceManagerAssignmentName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
