@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerConfigurationName The name of the workspace manager configuration
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceManagerConfigurationPlainArgs(
    public val resourceGroupName: String,
    public val workspaceManagerConfigurationName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerConfigurationPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceManagerConfigurationName(workspaceManagerConfigurationName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceManagerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceManagerConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceManagerConfigurationName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwbqxnjwltiloiln")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager configuration
     */
    @JvmName("wmsrnrxxbyrvgobw")
    public suspend fun workspaceManagerConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceManagerConfigurationName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ffghhajshunofgxj")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceManagerConfigurationPlainArgs =
        GetWorkspaceManagerConfigurationPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceManagerConfigurationName = workspaceManagerConfigurationName ?: throw
                PulumiNullFieldException("workspaceManagerConfigurationName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
