@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceManagerMemberName The name of the workspace manager member
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceManagerMemberPlainArgs(
    public val resourceGroupName: String,
    public val workspaceManagerMemberName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerMemberPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerMemberPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetWorkspaceManagerMemberPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceManagerMemberName(workspaceManagerMemberName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceManagerMemberPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceManagerMemberPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceManagerMemberName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tivlqilaehhwgpfk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace manager member
     */
    @JvmName("qnmvdsjstutimnxg")
    public suspend fun workspaceManagerMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceManagerMemberName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pstccjlgfnbftwjh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceManagerMemberPlainArgs = GetWorkspaceManagerMemberPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceManagerMemberName = workspaceManagerMemberName ?: throw
            PulumiNullFieldException("workspaceManagerMemberName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
