@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GroupingConfigurationArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AlertDetail
import com.pulumi.azurenative.securityinsights.kotlin.enums.EntityMappingType
import com.pulumi.azurenative.securityinsights.kotlin.enums.MatchingMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Grouping configuration property bag.
 * @property enabled Grouping enabled
 * @property groupByAlertDetails A list of alert details to group by (when matchingMethod is Selected)
 * @property groupByCustomDetails A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
 * @property groupByEntities A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
 * @property lookbackDuration Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
 * @property matchingMethod Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
 * @property reopenClosedIncident Re-open closed matching incidents
 */
public data class GroupingConfigurationArgs(
    public val enabled: Output<Boolean>,
    public val groupByAlertDetails: Output<List<Either<String, AlertDetail>>>? = null,
    public val groupByCustomDetails: Output<List<String>>? = null,
    public val groupByEntities: Output<List<Either<String, EntityMappingType>>>? = null,
    public val lookbackDuration: Output<String>,
    public val matchingMethod: Output<Either<String, MatchingMethod>>,
    public val reopenClosedIncident: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GroupingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GroupingConfigurationArgs =
        com.pulumi.azurenative.securityinsights.inputs.GroupingConfigurationArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .groupByAlertDetails(
                groupByAlertDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .groupByCustomDetails(groupByCustomDetails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupByEntities(
                groupByEntities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .lookbackDuration(lookbackDuration.applyValue({ args0 -> args0 }))
            .matchingMethod(
                matchingMethod.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .reopenClosedIncident(reopenClosedIncident.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupingConfigurationArgs].
 */
@PulumiTagMarker
public class GroupingConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var groupByAlertDetails: Output<List<Either<String, AlertDetail>>>? = null

    private var groupByCustomDetails: Output<List<String>>? = null

    private var groupByEntities: Output<List<Either<String, EntityMappingType>>>? = null

    private var lookbackDuration: Output<String>? = null

    private var matchingMethod: Output<Either<String, MatchingMethod>>? = null

    private var reopenClosedIncident: Output<Boolean>? = null

    /**
     * @param value Grouping enabled
     */
    @JvmName("pqvvmojduahwjjgy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of alert details to group by (when matchingMethod is Selected)
     */
    @JvmName("hcxmoxmblhowdaxq")
    public suspend fun groupByAlertDetails(`value`: Output<List<Either<String, AlertDetail>>>) {
        this.groupByAlertDetails = value
    }

    @JvmName("hviisaqrbppmabck")
    public suspend fun groupByAlertDetails(vararg values: Output<Either<String, AlertDetail>>) {
        this.groupByAlertDetails = Output.all(values.asList())
    }

    /**
     * @param values A list of alert details to group by (when matchingMethod is Selected)
     */
    @JvmName("hkkhrtbwdmcnryex")
    public suspend fun groupByAlertDetails(values: List<Output<Either<String, AlertDetail>>>) {
        this.groupByAlertDetails = Output.all(values)
    }

    /**
     * @param value A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
     */
    @JvmName("excsfwfiviehxlav")
    public suspend fun groupByCustomDetails(`value`: Output<List<String>>) {
        this.groupByCustomDetails = value
    }

    @JvmName("aejbjybbxblshmqf")
    public suspend fun groupByCustomDetails(vararg values: Output<String>) {
        this.groupByCustomDetails = Output.all(values.asList())
    }

    /**
     * @param values A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
     */
    @JvmName("cmoypjeibqqsnsce")
    public suspend fun groupByCustomDetails(values: List<Output<String>>) {
        this.groupByCustomDetails = Output.all(values)
    }

    /**
     * @param value A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
     */
    @JvmName("igplfcbsofrumqvw")
    public suspend fun groupByEntities(`value`: Output<List<Either<String, EntityMappingType>>>) {
        this.groupByEntities = value
    }

    @JvmName("fqohlnqjrgkgrbqj")
    public suspend fun groupByEntities(vararg values: Output<Either<String, EntityMappingType>>) {
        this.groupByEntities = Output.all(values.asList())
    }

    /**
     * @param values A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
     */
    @JvmName("vkxnmdmmwyndhdlc")
    public suspend fun groupByEntities(values: List<Output<Either<String, EntityMappingType>>>) {
        this.groupByEntities = Output.all(values)
    }

    /**
     * @param value Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
     */
    @JvmName("juvoptgpdkeeacet")
    public suspend fun lookbackDuration(`value`: Output<String>) {
        this.lookbackDuration = value
    }

    /**
     * @param value Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     */
    @JvmName("oyllygashcbufdxe")
    public suspend fun matchingMethod(`value`: Output<Either<String, MatchingMethod>>) {
        this.matchingMethod = value
    }

    /**
     * @param value Re-open closed matching incidents
     */
    @JvmName("fopskoicxibswwsy")
    public suspend fun reopenClosedIncident(`value`: Output<Boolean>) {
        this.reopenClosedIncident = value
    }

    /**
     * @param value Grouping enabled
     */
    @JvmName("ujaafpvkahoatmae")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of alert details to group by (when matchingMethod is Selected)
     */
    @JvmName("ynfemornwgfturpl")
    public suspend fun groupByAlertDetails(`value`: List<Either<String, AlertDetail>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupByAlertDetails = mapped
    }

    /**
     * @param values A list of alert details to group by (when matchingMethod is Selected)
     */
    @JvmName("hqqahomvqtwgsjkc")
    public suspend fun groupByAlertDetails(vararg values: Either<String, AlertDetail>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByAlertDetails = mapped
    }

    /**
     * @param value A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
     */
    @JvmName("nrcnpcbqaqcjdfjn")
    public suspend fun groupByCustomDetails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupByCustomDetails = mapped
    }

    /**
     * @param values A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
     */
    @JvmName("seqsxlowtlrtbqne")
    public suspend fun groupByCustomDetails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByCustomDetails = mapped
    }

    /**
     * @param value A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
     */
    @JvmName("gnwrkpoxrqqapeob")
    public suspend fun groupByEntities(`value`: List<Either<String, EntityMappingType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupByEntities = mapped
    }

    /**
     * @param values A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
     */
    @JvmName("duptjwjcslooojue")
    public suspend fun groupByEntities(vararg values: Either<String, EntityMappingType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByEntities = mapped
    }

    /**
     * @param value Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
     */
    @JvmName("hobbqwrofiuavslw")
    public suspend fun lookbackDuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lookbackDuration = mapped
    }

    /**
     * @param value Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     */
    @JvmName("ceaphaiuboljisen")
    public suspend fun matchingMethod(`value`: Either<String, MatchingMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingMethod = mapped
    }

    /**
     * @param value Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     */
    @JvmName("vhiohjfylmgrgpvx")
    public fun matchingMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MatchingMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingMethod = mapped
    }

    /**
     * @param value Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
     */
    @JvmName("fwxvpkwcjufaqylr")
    public fun matchingMethod(`value`: MatchingMethod) {
        val toBeMapped = Either.ofRight<String, MatchingMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingMethod = mapped
    }

    /**
     * @param value Re-open closed matching incidents
     */
    @JvmName("aanlxgrehthojcea")
    public suspend fun reopenClosedIncident(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reopenClosedIncident = mapped
    }

    internal fun build(): GroupingConfigurationArgs = GroupingConfigurationArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        groupByAlertDetails = groupByAlertDetails,
        groupByCustomDetails = groupByCustomDetails,
        groupByEntities = groupByEntities,
        lookbackDuration = lookbackDuration ?: throw PulumiNullFieldException("lookbackDuration"),
        matchingMethod = matchingMethod ?: throw PulumiNullFieldException("matchingMethod"),
        reopenClosedIncident = reopenClosedIncident ?: throw
            PulumiNullFieldException("reopenClosedIncident"),
    )
}
