@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.IncidentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Incident Configuration property bag.
 * @property createIncident Create incidents from alerts triggered by this analytics rule
 * @property groupingConfiguration Set how the alerts that are triggered by this analytics rule, are grouped into incidents
 */
public data class IncidentConfigurationArgs(
    public val createIncident: Output<Boolean>,
    public val groupingConfiguration: Output<GroupingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.IncidentConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.IncidentConfigurationArgs =
        com.pulumi.azurenative.securityinsights.inputs.IncidentConfigurationArgs.builder()
            .createIncident(createIncident.applyValue({ args0 -> args0 }))
            .groupingConfiguration(
                groupingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IncidentConfigurationArgs].
 */
@PulumiTagMarker
public class IncidentConfigurationArgsBuilder internal constructor() {
    private var createIncident: Output<Boolean>? = null

    private var groupingConfiguration: Output<GroupingConfigurationArgs>? = null

    /**
     * @param value Create incidents from alerts triggered by this analytics rule
     */
    @JvmName("aaivpvekyynsyasp")
    public suspend fun createIncident(`value`: Output<Boolean>) {
        this.createIncident = value
    }

    /**
     * @param value Set how the alerts that are triggered by this analytics rule, are grouped into incidents
     */
    @JvmName("qhlshjjeqgbcmglt")
    public suspend fun groupingConfiguration(`value`: Output<GroupingConfigurationArgs>) {
        this.groupingConfiguration = value
    }

    /**
     * @param value Create incidents from alerts triggered by this analytics rule
     */
    @JvmName("qccwmkgngygdgupi")
    public suspend fun createIncident(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createIncident = mapped
    }

    /**
     * @param value Set how the alerts that are triggered by this analytics rule, are grouped into incidents
     */
    @JvmName("oxvhfmqvsnjbmdyb")
    public suspend fun groupingConfiguration(`value`: GroupingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupingConfiguration = mapped
    }

    /**
     * @param argument Set how the alerts that are triggered by this analytics rule, are grouped into incidents
     */
    @JvmName("thxklocckayiusqt")
    public suspend
    fun groupingConfiguration(argument: suspend GroupingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GroupingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.groupingConfiguration = mapped
    }

    internal fun build(): IncidentConfigurationArgs = IncidentConfigurationArgs(
        createIncident = createIncident ?: throw PulumiNullFieldException("createIncident"),
        groupingConfiguration = groupingConfiguration,
    )
}
