@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.IncidentOwnerInfoArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.OwnerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information on the user an incident is assigned to
 * @property assignedTo The name of the user the incident is assigned to.
 * @property email The email of the user the incident is assigned to.
 * @property objectId The object id of the user the incident is assigned to.
 * @property ownerType The type of the owner the incident is assigned to.
 * @property userPrincipalName The user principal name of the user the incident is assigned to.
 */
public data class IncidentOwnerInfoArgs(
    public val assignedTo: Output<String>? = null,
    public val email: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val ownerType: Output<Either<String, OwnerType>>? = null,
    public val userPrincipalName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.IncidentOwnerInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.IncidentOwnerInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.IncidentOwnerInfoArgs.builder()
            .assignedTo(assignedTo?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .ownerType(
                ownerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userPrincipalName(userPrincipalName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentOwnerInfoArgs].
 */
@PulumiTagMarker
public class IncidentOwnerInfoArgsBuilder internal constructor() {
    private var assignedTo: Output<String>? = null

    private var email: Output<String>? = null

    private var objectId: Output<String>? = null

    private var ownerType: Output<Either<String, OwnerType>>? = null

    private var userPrincipalName: Output<String>? = null

    /**
     * @param value The name of the user the incident is assigned to.
     */
    @JvmName("lcidxdubtgwreykj")
    public suspend fun assignedTo(`value`: Output<String>) {
        this.assignedTo = value
    }

    /**
     * @param value The email of the user the incident is assigned to.
     */
    @JvmName("xmtsdosjpynywnkv")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The object id of the user the incident is assigned to.
     */
    @JvmName("sukfckwtdyscqxaw")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The type of the owner the incident is assigned to.
     */
    @JvmName("borjssptgygoonkk")
    public suspend fun ownerType(`value`: Output<Either<String, OwnerType>>) {
        this.ownerType = value
    }

    /**
     * @param value The user principal name of the user the incident is assigned to.
     */
    @JvmName("imhihcnuisuaxtyf")
    public suspend fun userPrincipalName(`value`: Output<String>) {
        this.userPrincipalName = value
    }

    /**
     * @param value The name of the user the incident is assigned to.
     */
    @JvmName("qewtjoyvoboqgdwh")
    public suspend fun assignedTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedTo = mapped
    }

    /**
     * @param value The email of the user the incident is assigned to.
     */
    @JvmName("rqedjmavanywsuka")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The object id of the user the incident is assigned to.
     */
    @JvmName("fcsosuewjfsugipo")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The type of the owner the incident is assigned to.
     */
    @JvmName("hnxdqsorinvwfmfk")
    public suspend fun ownerType(`value`: Either<String, OwnerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The type of the owner the incident is assigned to.
     */
    @JvmName("mipwlbdyrljqkoji")
    public fun ownerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OwnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The type of the owner the incident is assigned to.
     */
    @JvmName("vaymfcwspdiykfsa")
    public fun ownerType(`value`: OwnerType) {
        val toBeMapped = Either.ofRight<String, OwnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The user principal name of the user the incident is assigned to.
     */
    @JvmName("drcaonbdcstxjkxi")
    public suspend fun userPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPrincipalName = mapped
    }

    internal fun build(): IncidentOwnerInfoArgs = IncidentOwnerInfoArgs(
        assignedTo = assignedTo,
        email = email,
        objectId = objectId,
        ownerType = ownerType,
        userPrincipalName = userPrincipalName,
    )
}
