@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.InstructionStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Instruction step details, to be displayed in the Instructions steps section in the connector's page in Sentinel Portal.
 * @property parameters Gets or sets the instruction type parameters settings.
 * @property type Gets or sets the instruction type name.
 */
public data class InstructionStepDetailsArgs(
    public val parameters: Output<Any>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.InstructionStepDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.InstructionStepDetailsArgs =
        com.pulumi.azurenative.securityinsights.inputs.InstructionStepDetailsArgs.builder()
            .parameters(parameters.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstructionStepDetailsArgs].
 */
@PulumiTagMarker
public class InstructionStepDetailsArgsBuilder internal constructor() {
    private var parameters: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the instruction type parameters settings.
     */
    @JvmName("vgivwiqqvqcmbxus")
    public suspend fun parameters(`value`: Output<Any>) {
        this.parameters = value
    }

    /**
     * @param value Gets or sets the instruction type name.
     */
    @JvmName("oyepmaylrqottkwo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the instruction type parameters settings.
     */
    @JvmName("fhjuerewcdohxdjj")
    public suspend fun parameters(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Gets or sets the instruction type name.
     */
    @JvmName("vwiifsueiugdpywq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): InstructionStepDetailsArgs = InstructionStepDetailsArgs(
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
