@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The available data types for office data connector.
 * @property exchange Exchange data type connection.
 * @property sharePoint SharePoint data type connection.
 * @property teams Teams data type connection.
 */
public data class OfficeDataConnectorDataTypesArgs(
    public val exchange: Output<OfficeDataConnectorDataTypesExchangeArgs>? = null,
    public val sharePoint: Output<OfficeDataConnectorDataTypesSharePointArgs>? = null,
    public val teams: Output<OfficeDataConnectorDataTypesTeamsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs =
        com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs.builder()
            .exchange(exchange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sharePoint(sharePoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .teams(teams?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OfficeDataConnectorDataTypesArgs].
 */
@PulumiTagMarker
public class OfficeDataConnectorDataTypesArgsBuilder internal constructor() {
    private var exchange: Output<OfficeDataConnectorDataTypesExchangeArgs>? = null

    private var sharePoint: Output<OfficeDataConnectorDataTypesSharePointArgs>? = null

    private var teams: Output<OfficeDataConnectorDataTypesTeamsArgs>? = null

    /**
     * @param value Exchange data type connection.
     */
    @JvmName("axfiexvdfyjaygpp")
    public suspend fun exchange(`value`: Output<OfficeDataConnectorDataTypesExchangeArgs>) {
        this.exchange = value
    }

    /**
     * @param value SharePoint data type connection.
     */
    @JvmName("jywimxxtvagxpflb")
    public suspend fun sharePoint(`value`: Output<OfficeDataConnectorDataTypesSharePointArgs>) {
        this.sharePoint = value
    }

    /**
     * @param value Teams data type connection.
     */
    @JvmName("xjfsyvamlectrtrt")
    public suspend fun teams(`value`: Output<OfficeDataConnectorDataTypesTeamsArgs>) {
        this.teams = value
    }

    /**
     * @param value Exchange data type connection.
     */
    @JvmName("gfixjompbxkuykcu")
    public suspend fun exchange(`value`: OfficeDataConnectorDataTypesExchangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exchange = mapped
    }

    /**
     * @param argument Exchange data type connection.
     */
    @JvmName("vofxsfrrxloxdgfp")
    public suspend
    fun exchange(argument: suspend OfficeDataConnectorDataTypesExchangeArgsBuilder.() -> Unit) {
        val toBeMapped = OfficeDataConnectorDataTypesExchangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.exchange = mapped
    }

    /**
     * @param value SharePoint data type connection.
     */
    @JvmName("xjrluujcmrwdvgam")
    public suspend fun sharePoint(`value`: OfficeDataConnectorDataTypesSharePointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharePoint = mapped
    }

    /**
     * @param argument SharePoint data type connection.
     */
    @JvmName("gvuoccrtodqubvrk")
    public suspend
    fun sharePoint(argument: suspend OfficeDataConnectorDataTypesSharePointArgsBuilder.() -> Unit) {
        val toBeMapped = OfficeDataConnectorDataTypesSharePointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharePoint = mapped
    }

    /**
     * @param value Teams data type connection.
     */
    @JvmName("hkrifqhrecjspvvv")
    public suspend fun teams(`value`: OfficeDataConnectorDataTypesTeamsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teams = mapped
    }

    /**
     * @param argument Teams data type connection.
     */
    @JvmName("thshrguqtixnymbe")
    public suspend
    fun teams(argument: suspend OfficeDataConnectorDataTypesTeamsArgsBuilder.() -> Unit) {
        val toBeMapped = OfficeDataConnectorDataTypesTeamsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.teams = mapped
    }

    internal fun build(): OfficeDataConnectorDataTypesArgs = OfficeDataConnectorDataTypesArgs(
        exchange = exchange,
        sharePoint = sharePoint,
        teams = teams,
    )
}
