@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.SampleQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The sample queries for the connector.
 * @property description Gets or sets the  sample query description.
 * @property query Gets or sets the KQL sample query.
 */
public data class SampleQueryArgs(
    public val description: Output<String>,
    public val query: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.SampleQueryArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.SampleQueryArgs =
        com.pulumi.azurenative.securityinsights.inputs.SampleQueryArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .query(query.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SampleQueryArgs].
 */
@PulumiTagMarker
public class SampleQueryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var query: Output<String>? = null

    /**
     * @param value Gets or sets the  sample query description.
     */
    @JvmName("xkilubhbajssjpxn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the KQL sample query.
     */
    @JvmName("lavvnkvfffnrclcq")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Gets or sets the  sample query description.
     */
    @JvmName("acdrljugvllkavap")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the KQL sample query.
     */
    @JvmName("xhdkabgdedixiuqx")
    public suspend fun query(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): SampleQueryArgs = SampleQueryArgs(
        description = description ?: throw PulumiNullFieldException("description"),
        query = query ?: throw PulumiNullFieldException("query"),
    )
}
