@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.SecurityMLAnalyticsSettingsDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * security ml analytics settings data sources
 * @property connectorId The connector id that provides the following data types
 * @property dataTypes The data types used by the security ml analytics settings
 */
public data class SecurityMLAnalyticsSettingsDataSourceArgs(
    public val connectorId: Output<String>? = null,
    public val dataTypes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.SecurityMLAnalyticsSettingsDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.SecurityMLAnalyticsSettingsDataSourceArgs =
        com.pulumi.azurenative.securityinsights.inputs.SecurityMLAnalyticsSettingsDataSourceArgs.builder()
            .connectorId(connectorId?.applyValue({ args0 -> args0 }))
            .dataTypes(dataTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecurityMLAnalyticsSettingsDataSourceArgs].
 */
@PulumiTagMarker
public class SecurityMLAnalyticsSettingsDataSourceArgsBuilder internal constructor() {
    private var connectorId: Output<String>? = null

    private var dataTypes: Output<List<String>>? = null

    /**
     * @param value The connector id that provides the following data types
     */
    @JvmName("adobqmbcdenecmlv")
    public suspend fun connectorId(`value`: Output<String>) {
        this.connectorId = value
    }

    /**
     * @param value The data types used by the security ml analytics settings
     */
    @JvmName("rtuhwxwwcqtgbqjr")
    public suspend fun dataTypes(`value`: Output<List<String>>) {
        this.dataTypes = value
    }

    @JvmName("sqvtrwlasqpbvfrw")
    public suspend fun dataTypes(vararg values: Output<String>) {
        this.dataTypes = Output.all(values.asList())
    }

    /**
     * @param values The data types used by the security ml analytics settings
     */
    @JvmName("uwrjtynvytotagiq")
    public suspend fun dataTypes(values: List<Output<String>>) {
        this.dataTypes = Output.all(values)
    }

    /**
     * @param value The connector id that provides the following data types
     */
    @JvmName("armymlwcffxxhlwv")
    public suspend fun connectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorId = mapped
    }

    /**
     * @param value The data types used by the security ml analytics settings
     */
    @JvmName("xxwbobovrqvwrswy")
    public suspend fun dataTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param values The data types used by the security ml analytics settings
     */
    @JvmName("tktjfnhnjgypcluk")
    public suspend fun dataTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    internal fun build(): SecurityMLAnalyticsSettingsDataSourceArgs =
        SecurityMLAnalyticsSettingsDataSourceArgs(
            connectorId = connectorId,
            dataTypes = dataTypes,
        )
}
