@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceExternalReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes external reference
 * @property description External reference description
 * @property externalId External reference ID
 * @property hashes External reference hashes
 * @property sourceName External reference source name
 * @property url External reference URL
 */
public data class ThreatIntelligenceExternalReferenceArgs(
    public val description: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val hashes: Output<Map<String, String>>? = null,
    public val sourceName: Output<String>? = null,
    public val url: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceExternalReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceExternalReferenceArgs =
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceExternalReferenceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .hashes(hashes?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .sourceName(sourceName?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThreatIntelligenceExternalReferenceArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceExternalReferenceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var externalId: Output<String>? = null

    private var hashes: Output<Map<String, String>>? = null

    private var sourceName: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value External reference description
     */
    @JvmName("yaiybxovwcoulxmu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value External reference ID
     */
    @JvmName("xfbcoorixkogwqsk")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value External reference hashes
     */
    @JvmName("aygsfbnbagwkqymi")
    public suspend fun hashes(`value`: Output<Map<String, String>>) {
        this.hashes = value
    }

    /**
     * @param value External reference source name
     */
    @JvmName("aafcwfxuqbereolg")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value External reference URL
     */
    @JvmName("qqfifuhioduprbuk")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value External reference description
     */
    @JvmName("mvdqwwmsuypdtkfs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value External reference ID
     */
    @JvmName("qtkhvssyojvvlqts")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value External reference hashes
     */
    @JvmName("llofbogemojdslch")
    public suspend fun hashes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hashes = mapped
    }

    /**
     * @param values External reference hashes
     */
    @JvmName("hjvugdpevxhhohiw")
    public fun hashes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hashes = mapped
    }

    /**
     * @param value External reference source name
     */
    @JvmName("wyjjekqklodtovaa")
    public suspend fun sourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value External reference URL
     */
    @JvmName("okntrmffjnvlphuq")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ThreatIntelligenceExternalReferenceArgs =
        ThreatIntelligenceExternalReferenceArgs(
            description = description,
            externalId = externalId,
            hashes = hashes,
            sourceName = sourceName,
            url = url,
        )
}
