@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes parsed pattern entity
 * @property patternTypeKey Pattern type key
 * @property patternTypeValues Pattern type keys
 */
public data class ThreatIntelligenceParsedPatternArgs(
    public val patternTypeKey: Output<String>? = null,
    public val patternTypeValues: Output<List<ThreatIntelligenceParsedPatternTypeValueArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternArgs =
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceParsedPatternArgs.builder()
            .patternTypeKey(patternTypeKey?.applyValue({ args0 -> args0 }))
            .patternTypeValues(
                patternTypeValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ThreatIntelligenceParsedPatternArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceParsedPatternArgsBuilder internal constructor() {
    private var patternTypeKey: Output<String>? = null

    private var patternTypeValues: Output<List<ThreatIntelligenceParsedPatternTypeValueArgs>>? = null

    /**
     * @param value Pattern type key
     */
    @JvmName("ksaagoijovdatkot")
    public suspend fun patternTypeKey(`value`: Output<String>) {
        this.patternTypeKey = value
    }

    /**
     * @param value Pattern type keys
     */
    @JvmName("tpkrsyltnrrqkkkc")
    public suspend
    fun patternTypeValues(`value`: Output<List<ThreatIntelligenceParsedPatternTypeValueArgs>>) {
        this.patternTypeValues = value
    }

    @JvmName("dtfefavmboyowlvg")
    public suspend fun patternTypeValues(
        vararg
        values: Output<ThreatIntelligenceParsedPatternTypeValueArgs>,
    ) {
        this.patternTypeValues = Output.all(values.asList())
    }

    /**
     * @param values Pattern type keys
     */
    @JvmName("cqjjemieogulxetd")
    public suspend
    fun patternTypeValues(values: List<Output<ThreatIntelligenceParsedPatternTypeValueArgs>>) {
        this.patternTypeValues = Output.all(values)
    }

    /**
     * @param value Pattern type key
     */
    @JvmName("xyseaeqsbdgqxxtc")
    public suspend fun patternTypeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternTypeKey = mapped
    }

    /**
     * @param value Pattern type keys
     */
    @JvmName("yxjskcuocruardqf")
    public suspend
    fun patternTypeValues(`value`: List<ThreatIntelligenceParsedPatternTypeValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternTypeValues = mapped
    }

    /**
     * @param argument Pattern type keys
     */
    @JvmName("ewisgyfpxennhcyd")
    public suspend
    fun patternTypeValues(argument: List<suspend ThreatIntelligenceParsedPatternTypeValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceParsedPatternTypeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.patternTypeValues = mapped
    }

    /**
     * @param argument Pattern type keys
     */
    @JvmName("akyeoyrdulxiegdr")
    public suspend fun patternTypeValues(
        vararg
        argument: suspend ThreatIntelligenceParsedPatternTypeValueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThreatIntelligenceParsedPatternTypeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.patternTypeValues = mapped
    }

    /**
     * @param argument Pattern type keys
     */
    @JvmName("omtnedcklsqgwoxw")
    public suspend
    fun patternTypeValues(argument: suspend ThreatIntelligenceParsedPatternTypeValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThreatIntelligenceParsedPatternTypeValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.patternTypeValues = mapped
    }

    /**
     * @param values Pattern type keys
     */
    @JvmName("upohrlmrcbisnset")
    public suspend fun patternTypeValues(
        vararg
        values: ThreatIntelligenceParsedPatternTypeValueArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patternTypeValues = mapped
    }

    internal fun build(): ThreatIntelligenceParsedPatternArgs = ThreatIntelligenceParsedPatternArgs(
        patternTypeKey = patternTypeKey,
        patternTypeValues = patternTypeValues,
    )
}
