@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The criteria by which we determine whether the connector is connected or not.
 * For Example, use a KQL query to check if  the expected data type is flowing).
 * @property type Gets or sets the type of connectivity.
 * @property value Gets or sets the queries for checking connectivity.
 */
public data class ConnectivityCriterionResponse(
    public val type: String,
    public val `value`: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ConnectivityCriterionResponse):
            ConnectivityCriterionResponse = ConnectivityCriterionResponse(
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }),
        )
    }
}
