@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The UiConfig for 'Customizable' connector definition kind.
 * @property availability The exposure status of the connector to the customers.
 * @property connectivityCriteria Gets or sets the way the connector checks whether the connector is connected.
 * @property dataTypes Gets or sets the data types to check for last data received.
 * @property descriptionMarkdown Gets or sets the connector description in markdown format.
 * @property graphQueries Gets or sets the graph queries to show the current data volume over time.
 * @property graphQueriesTableName Gets or sets the name of the table the connector will insert the data to.
 * This name can be used in other queries by specifying {{graphQueriesTableName}} placeholder
 *  in Query and LastDataReceivedQuery values.
 * @property id Gets or sets custom connector id. optional field.
 * @property instructionSteps Gets or sets the instruction steps to enable the connector.
 * @property isConnectivityCriteriasMatchSome Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items.
 * @property logo Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
 * The logo value should be in SVG format.
 * @property permissions The required Permissions for the connector.
 * @property publisher Gets or sets the connector publisher name.
 * @property sampleQueries Gets or sets the sample queries for the connector.
 * @property title Gets or sets the connector blade title.
 */
public data class CustomizableConnectorUiConfigResponse(
    public val availability: ConnectorDefinitionsAvailabilityResponse? = null,
    public val connectivityCriteria: List<ConnectivityCriterionResponse>,
    public val dataTypes: List<ConnectorDataTypeResponse>,
    public val descriptionMarkdown: String,
    public val graphQueries: List<GraphQueryResponse>,
    public val graphQueriesTableName: String? = null,
    public val id: String? = null,
    public val instructionSteps: List<InstructionStepResponse>,
    public val isConnectivityCriteriasMatchSome: Boolean? = null,
    public val logo: String? = null,
    public val permissions: ConnectorDefinitionsPermissionsResponse,
    public val publisher: String,
    public val sampleQueries: List<SampleQueryResponse>,
    public val title: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.CustomizableConnectorUiConfigResponse):
            CustomizableConnectorUiConfigResponse = CustomizableConnectorUiConfigResponse(
            availability = javaType.availability().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ConnectorDefinitionsAvailabilityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectivityCriteria = javaType.connectivityCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ConnectivityCriterionResponse.Companion.toKotlin(args0)
                })
            }),
            dataTypes = javaType.dataTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ConnectorDataTypeResponse.Companion.toKotlin(args0)
                })
            }),
            descriptionMarkdown = javaType.descriptionMarkdown(),
            graphQueries = javaType.graphQueries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.GraphQueryResponse.Companion.toKotlin(args0)
                })
            }),
            graphQueriesTableName = javaType.graphQueriesTableName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            instructionSteps = javaType.instructionSteps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InstructionStepResponse.Companion.toKotlin(args0)
                })
            }),
            isConnectivityCriteriasMatchSome = javaType.isConnectivityCriteriasMatchSome().map({ args0 ->
                args0
            }).orElse(null),
            logo = javaType.logo().map({ args0 -> args0 }).orElse(null),
            permissions = javaType.permissions().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.ConnectorDefinitionsPermissionsResponse.Companion.toKotlin(args0)
            }),
            publisher = javaType.publisher(),
            sampleQueries = javaType.sampleQueries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.SampleQueryResponse.Companion.toKotlin(args0)
                })
            }),
            title = javaType.title(),
        )
    }
}
