@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Entity insight Item.
 * @property chartQueryResults Query results for table insights query.
 * @property queryId The query id of the insight
 * @property queryTimeInterval The Time interval that the query actually executed on.
 * @property tableQueryResults Query results for table insights query.
 */
public data class EntityInsightItemResponse(
    public val chartQueryResults: List<InsightsTableResultResponse>? = null,
    public val queryId: String? = null,
    public val queryTimeInterval: EntityInsightItemResponseQueryTimeInterval? = null,
    public val tableQueryResults: InsightsTableResultResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EntityInsightItemResponse):
            EntityInsightItemResponse = EntityInsightItemResponse(
            chartQueryResults = javaType.chartQueryResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InsightsTableResultResponse.Companion.toKotlin(args0)
                })
            }),
            queryId = javaType.queryId().map({ args0 -> args0 }).orElse(null),
            queryTimeInterval = javaType.queryTimeInterval().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EntityInsightItemResponseQueryTimeInterval.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tableQueryResults = javaType.tableQueryResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InsightsTableResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
