@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Single entity mapping for the alert rule
 * @property entityType The V3 type of the mapped entity
 * @property fieldMappings array of field mappings for the given entity mapping
 */
public data class EntityMappingResponse(
    public val entityType: String? = null,
    public val fieldMappings: List<FieldMappingResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EntityMappingResponse):
            EntityMappingResponse = EntityMappingResponse(
            entityType = javaType.entityType().map({ args0 -> args0 }).orElse(null),
            fieldMappings = javaType.fieldMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.FieldMappingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
