@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The workspace manager assignment
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property items List of resources included in this workspace manager assignment
 * @property lastJobEndTime The time the last job associated to this assignment ended at
 * @property lastJobProvisioningState State of the last job associated to this assignment
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetResourceName The resource name of the workspace manager group targeted by the workspace manager assignment
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceManagerAssignmentResult(
    public val etag: String,
    public val id: String,
    public val items: List<AssignmentItemResponse>,
    public val lastJobEndTime: String,
    public val lastJobProvisioningState: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val targetResourceName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetWorkspaceManagerAssignmentResult):
            GetWorkspaceManagerAssignmentResult = GetWorkspaceManagerAssignmentResult(
            etag = javaType.etag(),
            id = javaType.id(),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AssignmentItemResponse.Companion.toKotlin(args0)
                })
            }),
            lastJobEndTime = javaType.lastJobEndTime(),
            lastJobProvisioningState = javaType.lastJobProvisioningState(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetResourceName = javaType.targetResourceName(),
            type = javaType.type(),
        )
    }
}
