@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The workspace manager group
 * @property description The description of the workspace manager group
 * @property displayName The display name of the workspace manager group
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property memberResourceNames The names of the workspace manager members participating in this group.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceManagerGroupResult(
    public val description: String? = null,
    public val displayName: String,
    public val etag: String,
    public val id: String,
    public val memberResourceNames: List<String>,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetWorkspaceManagerGroupResult):
            GetWorkspaceManagerGroupResult = GetWorkspaceManagerGroupResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag(),
            id = javaType.id(),
            memberResourceNames = javaType.memberResourceNames().map({ args0 -> args0 }),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
