@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Instruction step details, to be displayed in the Instructions steps section in the connector's page in Sentinel Portal.
 * @property parameters Gets or sets the instruction type parameters settings.
 * @property type Gets or sets the instruction type name.
 */
public data class InstructionStepDetailsResponse(
    public val parameters: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.InstructionStepDetailsResponse):
            InstructionStepDetailsResponse = InstructionStepDetailsResponse(
            parameters = javaType.parameters(),
            type = javaType.type(),
        )
    }
}
