@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Suppress

/**
 * The available data types for office data connector.
 * @property exchange Exchange data type connection.
 * @property sharePoint SharePoint data type connection.
 * @property teams Teams data type connection.
 */
public data class OfficeDataConnectorDataTypesResponse(
    public val exchange: OfficeDataConnectorDataTypesResponseExchange? = null,
    public val sharePoint: OfficeDataConnectorDataTypesResponseSharePoint? = null,
    public val teams: OfficeDataConnectorDataTypesResponseTeams? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.OfficeDataConnectorDataTypesResponse):
            OfficeDataConnectorDataTypesResponse = OfficeDataConnectorDataTypesResponse(
            exchange = javaType.exchange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.OfficeDataConnectorDataTypesResponseExchange.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sharePoint = javaType.sharePoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.OfficeDataConnectorDataTypesResponseSharePoint.Companion.toKotlin(args0)
                })
            }).orElse(null),
            teams = javaType.teams().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.OfficeDataConnectorDataTypesResponseTeams.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
