@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.serialconsole.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the serial port of the parent resource.
 * @property id Resource Id
 * @property name Resource name
 * @property state Specifies whether the port is enabled for a serial console connection.
 * @property type Resource type
 */
public data class GetSerialPortResult(
    public val id: String,
    public val name: String,
    public val state: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.serialconsole.outputs.GetSerialPortResult):
            GetSerialPortResult = GetSerialPortResult(
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
