@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DisasterRecoveryConfig].
 */
@PulumiTagMarker
public class DisasterRecoveryConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DisasterRecoveryConfigArgs = DisasterRecoveryConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DisasterRecoveryConfigArgsBuilder.() -> Unit) {
        val builder = DisasterRecoveryConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DisasterRecoveryConfig {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.DisasterRecoveryConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DisasterRecoveryConfig(builtJavaResource)
    }
}

/**
 * Single item in List or Get Alias(Disaster Recovery configuration) operation
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### SBAliasCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disasterRecoveryConfig = new AzureNative.ServiceBus.DisasterRecoveryConfig("disasterRecoveryConfig", new()
 *     {
 *         Alias = "sdk-Namespace-8860",
 *         AlternateName = "alternameforAlias-Namespace-8860",
 *         NamespaceName = "sdk-Namespace-8860",
 *         PartnerNamespace = "sdk-Namespace-37",
 *         ResourceGroupName = "ardsouzatestRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewDisasterRecoveryConfig(ctx, "disasterRecoveryConfig", &servicebus.DisasterRecoveryConfigArgs{
 * 			Alias:             pulumi.String("sdk-Namespace-8860"),
 * 			AlternateName:     pulumi.String("alternameforAlias-Namespace-8860"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-8860"),
 * 			PartnerNamespace:  pulumi.String("sdk-Namespace-37"),
 * 			ResourceGroupName: pulumi.String("ardsouzatestRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.DisasterRecoveryConfig;
 * import com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disasterRecoveryConfig = new DisasterRecoveryConfig("disasterRecoveryConfig", DisasterRecoveryConfigArgs.builder()
 *             .alias("sdk-Namespace-8860")
 *             .alternateName("alternameforAlias-Namespace-8860")
 *             .namespaceName("sdk-Namespace-8860")
 *             .partnerNamespace("sdk-Namespace-37")
 *             .resourceGroupName("ardsouzatestRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:DisasterRecoveryConfig sdk-Namespace-8860 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}
 * ```
 */
public class DisasterRecoveryConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.DisasterRecoveryConfig,
) : KotlinCustomResource(javaResource, DisasterRecoveryConfigMapper) {
    /**
     * Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    public val alternateName: Output<String>?
        get() = javaResource.alternateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    public val partnerNamespace: Output<String>?
        get() = javaResource.partnerNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of entities pending to be replicated.
     */
    public val pendingReplicationOperationsCount: Output<Double>
        get() = javaResource.pendingReplicationOperationsCount().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded' or 'Failed'
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DisasterRecoveryConfigMapper : ResourceMapper<DisasterRecoveryConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.DisasterRecoveryConfig::class == javaResource::class

    override fun map(javaResource: Resource): DisasterRecoveryConfig =
        DisasterRecoveryConfig(
            javaResource as
                com.pulumi.azurenative.servicebus.DisasterRecoveryConfig,
        )
}

/**
 * @see [DisasterRecoveryConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DisasterRecoveryConfig].
 */
public suspend fun disasterRecoveryConfig(
    name: String,
    block: suspend DisasterRecoveryConfigResourceBuilder.() -> Unit,
): DisasterRecoveryConfig {
    val builder = DisasterRecoveryConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DisasterRecoveryConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disasterRecoveryConfig(name: String): DisasterRecoveryConfig {
    val builder = DisasterRecoveryConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
