@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MigrationConfig].
 */
@PulumiTagMarker
public class MigrationConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrationConfigArgs = MigrationConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrationConfigArgsBuilder.() -> Unit) {
        val builder = MigrationConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MigrationConfig {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.MigrationConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MigrationConfig(builtJavaResource)
    }
}

/**
 * Single item in List or Get Migration Config operation
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### MigrationConfigurationsStartMigration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrationConfig = new AzureNative.ServiceBus.MigrationConfig("migrationConfig", new()
 *     {
 *         ConfigName = "$default",
 *         NamespaceName = "sdk-Namespace-41",
 *         PostMigrationName = "sdk-PostMigration-5919",
 *         ResourceGroupName = "ResourceGroup",
 *         TargetNamespace = "/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewMigrationConfig(ctx, "migrationConfig", &servicebus.MigrationConfigArgs{
 * 			ConfigName:        pulumi.String("$default"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-41"),
 * 			PostMigrationName: pulumi.String("sdk-PostMigration-5919"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 			TargetNamespace:   pulumi.String("/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.MigrationConfig;
 * import com.pulumi.azurenative.servicebus.MigrationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrationConfig = new MigrationConfig("migrationConfig", MigrationConfigArgs.builder()
 *             .configName("$default")
 *             .namespaceName("sdk-Namespace-41")
 *             .postMigrationName("sdk-PostMigration-5919")
 *             .resourceGroupName("ResourceGroup")
 *             .targetNamespace("/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:MigrationConfig sdk-Namespace-41 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}
 * ```
 */
public class MigrationConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.MigrationConfig,
) : KotlinCustomResource(javaResource, MigrationConfigMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating, Syncing, Active
     */
    public val migrationState: Output<String>
        get() = javaResource.migrationState().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of entities pending to be replicated.
     */
    public val pendingReplicationOperationsCount: Output<Double>
        get() = javaResource.pendingReplicationOperationsCount().applyValue({ args0 -> args0 })

    /**
     * Name to access Standard Namespace after migration
     */
    public val postMigrationName: Output<String>
        get() = javaResource.postMigrationName().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of Migration Configuration
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Existing premium Namespace ARM Id name which has no entities, will be used for migration
     */
    public val targetNamespace: Output<String>
        get() = javaResource.targetNamespace().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MigrationConfigMapper : ResourceMapper<MigrationConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.MigrationConfig::class == javaResource::class

    override fun map(javaResource: Resource): MigrationConfig = MigrationConfig(
        javaResource as
            com.pulumi.azurenative.servicebus.MigrationConfig,
    )
}

/**
 * @see [MigrationConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrationConfig].
 */
public suspend fun migrationConfig(
    name: String,
    block: suspend MigrationConfigResourceBuilder.() -> Unit,
): MigrationConfig {
    val builder = MigrationConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrationConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrationConfig(name: String): MigrationConfig {
    val builder = MigrationConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
