@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.NamespaceArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.servicebus.kotlin.enums.TlsVersion
import com.pulumi.azurenative.servicebus.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.SBSkuArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.SBSkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Description of a namespace resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### NameSpaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.ServiceBus.Namespace("namespace", new()
 *     {
 *         Location = "South Central US",
 *         NamespaceName = "sdk-Namespace2924",
 *         ResourceGroupName = "ArunMonocle",
 *         Sku = new AzureNative.ServiceBus.Inputs.SBSkuArgs
 *         {
 *             Name = "Standard",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespace(ctx, "namespace", &servicebus.NamespaceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace2924"),
 * 			ResourceGroupName: pulumi.String("ArunMonocle"),
 * 			Sku: &servicebus.SBSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Namespace;
 * import com.pulumi.azurenative.servicebus.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("South Central US")
 *             .namespaceName("sdk-Namespace2924")
 *             .resourceGroupName("ArunMonocle")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Namespace sdk-Namespace-2924 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}
 * ```
 * @property alternateName Alternate name for namespace
 * @property disableLocalAuth This property disables SAS authentication for the Service Bus namespace.
 * @property encryption Properties of BYOK Encryption description
 * @property identity Properties of BYOK Identity description
 * @property location The Geo-location where the resource lives
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property namespaceName The namespace name.
 * @property privateEndpointConnections List of private endpoint connections.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sku Properties of SKU
 * @property tags Resource tags
 * @property zoneRedundant Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
 */
public data class NamespaceArgs(
    public val alternateName: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, TlsVersion>>? = null,
    public val namespaceName: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SBSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.NamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.NamespaceArgs =
        com.pulumi.azurenative.servicebus.NamespaceArgs.builder()
            .alternateName(alternateName?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var alternateName: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, TlsVersion>>? = null

    private var namespaceName: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SBSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value Alternate name for namespace
     */
    @JvmName("uvjfyhijrrsuweeg")
    public suspend fun alternateName(`value`: Output<String>) {
        this.alternateName = value
    }

    /**
     * @param value This property disables SAS authentication for the Service Bus namespace.
     */
    @JvmName("tspmpihchscsugeo")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Properties of BYOK Encryption description
     */
    @JvmName("nqpyapavnmyofjhv")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Properties of BYOK Identity description
     */
    @JvmName("afgayhyhlaweelbe")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The Geo-location where the resource lives
     */
    @JvmName("fomktldgndiqanix")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("rwoulqgbatudalxo")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, TlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value The namespace name.
     */
    @JvmName("xjmnkqxovrvgsblg")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gfdentlriowbhyrw")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("gmlwcthlveytirgu")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tbjfajgdgwkuejkt")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("kdbjionfwmohrggx")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("gugaytswdmxpbdxl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Properties of SKU
     */
    @JvmName("alrcpbevpglelvmq")
    public suspend fun sku(`value`: Output<SBSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("olovaxklpbbgerey")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
     */
    @JvmName("tepbetumvxeinvwq")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value Alternate name for namespace
     */
    @JvmName("awjjqykmgjuuocjs")
    public suspend fun alternateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateName = mapped
    }

    /**
     * @param value This property disables SAS authentication for the Service Bus namespace.
     */
    @JvmName("wgfsdpjccdgbivtp")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Properties of BYOK Encryption description
     */
    @JvmName("afjcjeyudtpcvapj")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Properties of BYOK Encryption description
     */
    @JvmName("gnfeiggpcurkvhue")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Properties of BYOK Identity description
     */
    @JvmName("bqimuoxuluaaicjw")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Properties of BYOK Identity description
     */
    @JvmName("cpbtysgkwvrollie")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The Geo-location where the resource lives
     */
    @JvmName("uyvvsbnfuuibdjtj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("rlnqtgvnalpebfmw")
    public suspend fun minimumTlsVersion(`value`: Either<String, TlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("jogysxbkfilehbdb")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("vsilgsaeyxypbueq")
    public fun minimumTlsVersion(`value`: TlsVersion) {
        val toBeMapped = Either.ofRight<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The namespace name.
     */
    @JvmName("ddmflbqpjkuchtel")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xpgolewjhnxpqnrm")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("sdfpjrykqhlhfakw")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hpxuqugcfhkcqahe")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bwbakygfohkkfprb")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("roblanwbrnbsposd")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("nrcavaywrrxtessv")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("imykwvylaqymqpgl")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("warjhpheqpdrvsna")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("euulskfdobeambwn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Properties of SKU
     */
    @JvmName("qttvfucxanluxjfd")
    public suspend fun sku(`value`: SBSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Properties of SKU
     */
    @JvmName("efgcbgbpayhwythc")
    public suspend fun sku(argument: suspend SBSkuArgsBuilder.() -> Unit) {
        val toBeMapped = SBSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qgqwegwsheaddned")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("fqaddmntmbhvfkbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
     */
    @JvmName("respvkqkgwyaaayp")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        alternateName = alternateName,
        disableLocalAuth = disableLocalAuth,
        encryption = encryption,
        identity = identity,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        namespaceName = namespaceName,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zoneRedundant = zoneRedundant,
    )
}
