@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.QueueAuthorizationRuleArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of a namespace authorization rule.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### QueueAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queueAuthorizationRule = new AzureNative.ServiceBus.QueueAuthorizationRule("queueAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-AuthRules-5800",
 *         NamespaceName = "sdk-Namespace-7982",
 *         QueueName = "sdk-Queues-2317",
 *         ResourceGroupName = "ArunMonocle",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewQueueAuthorizationRule(ctx, "queueAuthorizationRule", &servicebus.QueueAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-AuthRules-5800"),
 * 			NamespaceName:         pulumi.String("sdk-Namespace-7982"),
 * 			QueueName:             pulumi.String("sdk-Queues-2317"),
 * 			ResourceGroupName:     pulumi.String("ArunMonocle"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.QueueAuthorizationRule;
 * import com.pulumi.azurenative.servicebus.QueueAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queueAuthorizationRule = new QueueAuthorizationRule("queueAuthorizationRule", QueueAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-AuthRules-5800")
 *             .namespaceName("sdk-Namespace-7982")
 *             .queueName("sdk-Queues-2317")
 *             .resourceGroupName("ArunMonocle")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:QueueAuthorizationRule sdk-AuthRules-5800 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property queueName The queue name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rights The rights associated with the rule.
 */
public data class QueueAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val queueName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.QueueAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.QueueAuthorizationRuleArgs =
        com.pulumi.azurenative.servicebus.QueueAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [QueueAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class QueueAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var queueName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("vixreoebfnkibwvp")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("btfkgxborosdtooi")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The queue name.
     */
    @JvmName("brsklnfdbxecbori")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wywjfpunnjturjjv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("ruptqtblkmlwatyc")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("ouafdoboymqaoabx")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("tworjctnhrjqxqui")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("jjpcjuvjueegjdwh")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("bewiuggocvxejtop")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The queue name.
     */
    @JvmName("pwnhteeohidfeibh")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("idcltmacxtmlgbpy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("jplavpoylverotkg")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("fephmruxtvoainfv")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): QueueAuthorizationRuleArgs = QueueAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        namespaceName = namespaceName,
        queueName = queueName,
        resourceGroupName = resourceGroupName,
        rights = rights,
    )
}
