@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.ServicebusFunctions.getDisasterRecoveryConfigPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getMigrationConfigPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getNamespaceAuthorizationRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getNamespaceIpFilterRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getNamespaceNetworkRuleSetPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getNamespacePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getNamespaceVirtualNetworkRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getQueueAuthorizationRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getQueuePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getSubscriptionPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getTopicAuthorizationRulePlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.getTopicPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.listDisasterRecoveryConfigKeysPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.listNamespaceKeysPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.listQueueKeysPlain
import com.pulumi.azurenative.servicebus.ServicebusFunctions.listTopicKeysPlain
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetDisasterRecoveryConfigPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetDisasterRecoveryConfigPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetMigrationConfigPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetMigrationConfigPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceIpFilterRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceIpFilterRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceNetworkRuleSetPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceNetworkRuleSetPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceVirtualNetworkRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetNamespaceVirtualNetworkRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetQueueAuthorizationRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetQueueAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetQueuePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetQueuePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetSubscriptionPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetTopicAuthorizationRulePlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetTopicAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetTopicPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.GetTopicPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListDisasterRecoveryConfigKeysPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListDisasterRecoveryConfigKeysPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListNamespaceKeysPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListNamespaceKeysPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListQueueKeysPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListQueueKeysPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListTopicKeysPlainArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ListTopicKeysPlainArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetDisasterRecoveryConfigResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetMigrationConfigResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceAuthorizationRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceIpFilterRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceNetworkRuleSetResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceVirtualNetworkRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetQueueAuthorizationRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetQueueResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetSubscriptionResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetTopicAuthorizationRuleResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetTopicResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListDisasterRecoveryConfigKeysResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListNamespaceKeysResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListQueueKeysResult
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListTopicKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetDisasterRecoveryConfigResult.Companion.toKotlin as getDisasterRecoveryConfigResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetMigrationConfigResult.Companion.toKotlin as getMigrationConfigResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceAuthorizationRuleResult.Companion.toKotlin as getNamespaceAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceIpFilterRuleResult.Companion.toKotlin as getNamespaceIpFilterRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceNetworkRuleSetResult.Companion.toKotlin as getNamespaceNetworkRuleSetResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetNamespaceVirtualNetworkRuleResult.Companion.toKotlin as getNamespaceVirtualNetworkRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetQueueAuthorizationRuleResult.Companion.toKotlin as getQueueAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetQueueResult.Companion.toKotlin as getQueueResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetRuleResult.Companion.toKotlin as getRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetSubscriptionResult.Companion.toKotlin as getSubscriptionResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetTopicAuthorizationRuleResult.Companion.toKotlin as getTopicAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.GetTopicResult.Companion.toKotlin as getTopicResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListDisasterRecoveryConfigKeysResult.Companion.toKotlin as listDisasterRecoveryConfigKeysResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListNamespaceKeysResult.Companion.toKotlin as listNamespaceKeysResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListQueueKeysResult.Companion.toKotlin as listQueueKeysResultToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.ListTopicKeysResult.Companion.toKotlin as listTopicKeysResultToKotlin

public object ServicebusFunctions {
    /**
     * Retrieves Alias(Disaster Recovery configuration) for primary or secondary namespace
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend fun getDisasterRecoveryConfig(argument: GetDisasterRecoveryConfigPlainArgs):
        GetDisasterRecoveryConfigResult =
        getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(argument.toJava()).await())

    /**
     * @see [getDisasterRecoveryConfig].
     * @param alias The Disaster Recovery configuration name
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend fun getDisasterRecoveryConfig(
        alias: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetDisasterRecoveryConfigResult {
        val argument = GetDisasterRecoveryConfigPlainArgs(
            alias = alias,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisasterRecoveryConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetDisasterRecoveryConfigPlainArgs].
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend
    fun getDisasterRecoveryConfig(argument: suspend GetDisasterRecoveryConfigPlainArgsBuilder.() -> Unit):
        GetDisasterRecoveryConfigResult {
        val builder = GetDisasterRecoveryConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves Migration Config
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Single item in List or Get Migration Config operation
     */
    public suspend fun getMigrationConfig(argument: GetMigrationConfigPlainArgs):
        GetMigrationConfigResult =
        getMigrationConfigResultToKotlin(getMigrationConfigPlain(argument.toJava()).await())

    /**
     * @see [getMigrationConfig].
     * @param configName The configuration name. Should always be "$default".
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in List or Get Migration Config operation
     */
    public suspend fun getMigrationConfig(
        configName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetMigrationConfigResult {
        val argument = GetMigrationConfigPlainArgs(
            configName = configName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getMigrationConfigResultToKotlin(getMigrationConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrationConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetMigrationConfigPlainArgs].
     * @return Single item in List or Get Migration Config operation
     */
    public suspend
    fun getMigrationConfig(argument: suspend GetMigrationConfigPlainArgsBuilder.() -> Unit):
        GetMigrationConfigResult {
        val builder = GetMigrationConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrationConfigResultToKotlin(getMigrationConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a description for the specified namespace.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(namespaceName: String, resourceGroupName: String):
        GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit):
        GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an authorization rule for a namespace by rule name.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of a namespace authorization rule.
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: GetNamespaceAuthorizationRulePlainArgs):
        GetNamespaceAuthorizationRuleResult =
        getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of a namespace authorization rule.
     */
    public suspend fun getNamespaceAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceAuthorizationRuleResult {
        val argument = GetNamespaceAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetNamespaceAuthorizationRulePlainArgs].
     * @return Description of a namespace authorization rule.
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: suspend GetNamespaceAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetNamespaceAuthorizationRuleResult {
        val builder = GetNamespaceAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an IpFilterRule for a Namespace by rule name.
     * Azure REST API version: 2018-01-01-preview.
     * @param argument null
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend fun getNamespaceIpFilterRule(argument: GetNamespaceIpFilterRulePlainArgs):
        GetNamespaceIpFilterRuleResult =
        getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceIpFilterRule].
     * @param ipFilterRuleName The IP Filter Rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend fun getNamespaceIpFilterRule(
        ipFilterRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceIpFilterRuleResult {
        val argument = GetNamespaceIpFilterRulePlainArgs(
            ipFilterRuleName = ipFilterRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceIpFilterRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetNamespaceIpFilterRulePlainArgs].
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend
    fun getNamespaceIpFilterRule(argument: suspend GetNamespaceIpFilterRulePlainArgsBuilder.() -> Unit):
        GetNamespaceIpFilterRuleResult {
        val builder = GetNamespaceIpFilterRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets NetworkRuleSet for a Namespace.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Description of NetworkRuleSet resource.
     */
    public suspend fun getNamespaceNetworkRuleSet(argument: GetNamespaceNetworkRuleSetPlainArgs):
        GetNamespaceNetworkRuleSetResult =
        getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(argument.toJava()).await())

    /**
     * @see [getNamespaceNetworkRuleSet].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of NetworkRuleSet resource.
     */
    public suspend fun getNamespaceNetworkRuleSet(namespaceName: String, resourceGroupName: String):
        GetNamespaceNetworkRuleSetResult {
        val argument = GetNamespaceNetworkRuleSetPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceNetworkRuleSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetNamespaceNetworkRuleSetPlainArgs].
     * @return Description of NetworkRuleSet resource.
     */
    public suspend
    fun getNamespaceNetworkRuleSet(argument: suspend GetNamespaceNetworkRuleSetPlainArgsBuilder.() -> Unit):
        GetNamespaceNetworkRuleSetResult {
        val builder = GetNamespaceNetworkRuleSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an VirtualNetworkRule for a Namespace by rule name.
     * Azure REST API version: 2018-01-01-preview.
     * @param argument null
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend
    fun getNamespaceVirtualNetworkRule(argument: GetNamespaceVirtualNetworkRulePlainArgs):
        GetNamespaceVirtualNetworkRuleResult =
        getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceVirtualNetworkRule].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param virtualNetworkRuleName The Virtual Network Rule name.
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend fun getNamespaceVirtualNetworkRule(
        namespaceName: String,
        resourceGroupName: String,
        virtualNetworkRuleName: String,
    ): GetNamespaceVirtualNetworkRuleResult {
        val argument = GetNamespaceVirtualNetworkRulePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            virtualNetworkRuleName = virtualNetworkRuleName,
        )
        return getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceVirtualNetworkRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetNamespaceVirtualNetworkRulePlainArgs].
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend
    fun getNamespaceVirtualNetworkRule(argument: suspend GetNamespaceVirtualNetworkRulePlainArgsBuilder.() -> Unit):
        GetNamespaceVirtualNetworkRuleResult {
        val builder = GetNamespaceVirtualNetworkRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a description for the specified Private Endpoint Connection.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param namespaceName The namespace name
     * @param privateEndpointConnectionName The PrivateEndpointConnection name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(
        namespaceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            namespaceName = namespaceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a description for the specified queue.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of queue Resource.
     */
    public suspend fun getQueue(argument: GetQueuePlainArgs): GetQueueResult =
        getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())

    /**
     * @see [getQueue].
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of queue Resource.
     */
    public suspend fun getQueue(
        namespaceName: String,
        queueName: String,
        resourceGroupName: String,
    ): GetQueueResult {
        val argument = GetQueuePlainArgs(
            namespaceName = namespaceName,
            queueName = queueName,
            resourceGroupName = resourceGroupName,
        )
        return getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetQueuePlainArgs].
     * @return Description of queue Resource.
     */
    public suspend fun getQueue(argument: suspend GetQueuePlainArgsBuilder.() -> Unit):
        GetQueueResult {
        val builder = GetQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueResultToKotlin(getQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an authorization rule for a queue by rule name.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of a namespace authorization rule.
     */
    public suspend fun getQueueAuthorizationRule(argument: GetQueueAuthorizationRulePlainArgs):
        GetQueueAuthorizationRuleResult =
        getQueueAuthorizationRuleResultToKotlin(getQueueAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getQueueAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of a namespace authorization rule.
     */
    public suspend fun getQueueAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        queueName: String,
        resourceGroupName: String,
    ): GetQueueAuthorizationRuleResult {
        val argument = GetQueueAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            queueName = queueName,
            resourceGroupName = resourceGroupName,
        )
        return getQueueAuthorizationRuleResultToKotlin(getQueueAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueueAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetQueueAuthorizationRulePlainArgs].
     * @return Description of a namespace authorization rule.
     */
    public suspend
    fun getQueueAuthorizationRule(argument: suspend GetQueueAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetQueueAuthorizationRuleResult {
        val builder = GetQueueAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueAuthorizationRuleResultToKotlin(getQueueAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the description for the specified rule.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Description of Rule Resource.
     */
    public suspend fun getRule(argument: GetRulePlainArgs): GetRuleResult =
        getRuleResultToKotlin(getRulePlain(argument.toJava()).await())

    /**
     * @see [getRule].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param ruleName The rule name.
     * @param subscriptionName The subscription name.
     * @param topicName The topic name.
     * @return Description of Rule Resource.
     */
    public suspend fun getRule(
        namespaceName: String,
        resourceGroupName: String,
        ruleName: String,
        subscriptionName: String,
        topicName: String,
    ): GetRuleResult {
        val argument = GetRulePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
            subscriptionName = subscriptionName,
            topicName = topicName,
        )
        return getRuleResultToKotlin(getRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetRulePlainArgs].
     * @return Description of Rule Resource.
     */
    public suspend fun getRule(argument: suspend GetRulePlainArgsBuilder.() -> Unit): GetRuleResult {
        val builder = GetRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuleResultToKotlin(getRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a subscription description for the specified topic.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of subscription resource.
     */
    public suspend fun getSubscription(argument: GetSubscriptionPlainArgs): GetSubscriptionResult =
        getSubscriptionResultToKotlin(getSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getSubscription].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param subscriptionName The subscription name.
     * @param topicName The topic name.
     * @return Description of subscription resource.
     */
    public suspend fun getSubscription(
        namespaceName: String,
        resourceGroupName: String,
        subscriptionName: String,
        topicName: String,
    ): GetSubscriptionResult {
        val argument = GetSubscriptionPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            subscriptionName = subscriptionName,
            topicName = topicName,
        )
        return getSubscriptionResultToKotlin(getSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetSubscriptionPlainArgs].
     * @return Description of subscription resource.
     */
    public suspend fun getSubscription(argument: suspend GetSubscriptionPlainArgsBuilder.() -> Unit):
        GetSubscriptionResult {
        val builder = GetSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscriptionResultToKotlin(getSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a description for the specified topic.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of topic resource.
     */
    public suspend fun getTopic(argument: GetTopicPlainArgs): GetTopicResult =
        getTopicResultToKotlin(getTopicPlain(argument.toJava()).await())

    /**
     * @see [getTopic].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param topicName The topic name.
     * @return Description of topic resource.
     */
    public suspend fun getTopic(
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetTopicResult {
        val argument = GetTopicPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicResultToKotlin(getTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetTopicPlainArgs].
     * @return Description of topic resource.
     */
    public suspend fun getTopic(argument: suspend GetTopicPlainArgsBuilder.() -> Unit):
        GetTopicResult {
        val builder = GetTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicResultToKotlin(getTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the specified authorization rule.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Description of a namespace authorization rule.
     */
    public suspend fun getTopicAuthorizationRule(argument: GetTopicAuthorizationRulePlainArgs):
        GetTopicAuthorizationRuleResult =
        getTopicAuthorizationRuleResultToKotlin(getTopicAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getTopicAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param topicName The topic name.
     * @return Description of a namespace authorization rule.
     */
    public suspend fun getTopicAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetTopicAuthorizationRuleResult {
        val argument = GetTopicAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicAuthorizationRuleResultToKotlin(getTopicAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;GetTopicAuthorizationRulePlainArgs].
     * @return Description of a namespace authorization rule.
     */
    public suspend
    fun getTopicAuthorizationRule(argument: suspend GetTopicAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetTopicAuthorizationRuleResult {
        val builder = GetTopicAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicAuthorizationRuleResultToKotlin(getTopicAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2022-10-01-preview.
     * @param argument null
     * @return Namespace/ServiceBus Connection String
     */
    public suspend
    fun listDisasterRecoveryConfigKeys(argument: ListDisasterRecoveryConfigKeysPlainArgs):
        ListDisasterRecoveryConfigKeysResult =
        listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(argument.toJava()).await())

    /**
     * @see [listDisasterRecoveryConfigKeys].
     * @param alias The Disaster Recovery configuration name
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listDisasterRecoveryConfigKeys(
        alias: String,
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListDisasterRecoveryConfigKeysResult {
        val argument = ListDisasterRecoveryConfigKeysPlainArgs(
            alias = alias,
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listDisasterRecoveryConfigKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;ListDisasterRecoveryConfigKeysPlainArgs].
     * @return Namespace/ServiceBus Connection String
     */
    public suspend
    fun listDisasterRecoveryConfigKeys(argument: suspend ListDisasterRecoveryConfigKeysPlainArgsBuilder.() -> Unit):
        ListDisasterRecoveryConfigKeysResult {
        val builder = ListDisasterRecoveryConfigKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listNamespaceKeys(argument: ListNamespaceKeysPlainArgs):
        ListNamespaceKeysResult =
        listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listNamespaceKeys(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListNamespaceKeysResult {
        val argument = ListNamespaceKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;ListNamespaceKeysPlainArgs].
     * @return Namespace/ServiceBus Connection String
     */
    public suspend
    fun listNamespaceKeys(argument: suspend ListNamespaceKeysPlainArgsBuilder.() -> Unit):
        ListNamespaceKeysResult {
        val builder = ListNamespaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Primary and secondary connection strings to the queue.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listQueueKeys(argument: ListQueueKeysPlainArgs): ListQueueKeysResult =
        listQueueKeysResultToKotlin(listQueueKeysPlain(argument.toJava()).await())

    /**
     * @see [listQueueKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listQueueKeys(
        authorizationRuleName: String,
        namespaceName: String,
        queueName: String,
        resourceGroupName: String,
    ): ListQueueKeysResult {
        val argument = ListQueueKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            queueName = queueName,
            resourceGroupName = resourceGroupName,
        )
        return listQueueKeysResultToKotlin(listQueueKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listQueueKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;ListQueueKeysPlainArgs].
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listQueueKeys(argument: suspend ListQueueKeysPlainArgsBuilder.() -> Unit):
        ListQueueKeysResult {
        val builder = ListQueueKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listQueueKeysResultToKotlin(listQueueKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the primary and secondary connection strings for the topic.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2015-08-01, 2022-10-01-preview.
     * @param argument null
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listTopicKeys(argument: ListTopicKeysPlainArgs): ListTopicKeysResult =
        listTopicKeysResultToKotlin(listTopicKeysPlain(argument.toJava()).await())

    /**
     * @see [listTopicKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param topicName The topic name.
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listTopicKeys(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): ListTopicKeysResult {
        val argument = ListTopicKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return listTopicKeysResultToKotlin(listTopicKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listTopicKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicebus&#46;kotlin&#46;inputs&#46;ListTopicKeysPlainArgs].
     * @return Namespace/ServiceBus Connection String
     */
    public suspend fun listTopicKeys(argument: suspend ListTopicKeysPlainArgsBuilder.() -> Unit):
        ListTopicKeysResult {
        val builder = ListTopicKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTopicKeysResultToKotlin(listTopicKeysPlain(builtArgument.toJava()).await())
    }
}
