@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TopicAuthorizationRule].
 */
@PulumiTagMarker
public class TopicAuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicAuthorizationRuleArgs = TopicAuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicAuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = TopicAuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TopicAuthorizationRule {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.TopicAuthorizationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TopicAuthorizationRule(builtJavaResource)
    }
}

/**
 * Description of a namespace authorization rule.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### TopicAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topicAuthorizationRule = new AzureNative.ServiceBus.TopicAuthorizationRule("topicAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-AuthRules-4310",
 *         NamespaceName = "sdk-Namespace-6261",
 *         ResourceGroupName = "ArunMonocle",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *         TopicName = "sdk-Topics-1984",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewTopicAuthorizationRule(ctx, "topicAuthorizationRule", &servicebus.TopicAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-AuthRules-4310"),
 * 			NamespaceName:         pulumi.String("sdk-Namespace-6261"),
 * 			ResourceGroupName:     pulumi.String("ArunMonocle"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 			TopicName: pulumi.String("sdk-Topics-1984"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.TopicAuthorizationRule;
 * import com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topicAuthorizationRule = new TopicAuthorizationRule("topicAuthorizationRule", TopicAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-AuthRules-4310")
 *             .namespaceName("sdk-Namespace-6261")
 *             .resourceGroupName("ArunMonocle")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .topicName("sdk-Topics-1984")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:TopicAuthorizationRule sdk-AuthRules-4310 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}
 * ```
 */
public class TopicAuthorizationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.TopicAuthorizationRule,
) : KotlinCustomResource(javaResource, TopicAuthorizationRuleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The rights associated with the rule.
     */
    public val rights: Output<List<String>>
        get() = javaResource.rights().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TopicAuthorizationRuleMapper : ResourceMapper<TopicAuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.TopicAuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): TopicAuthorizationRule =
        TopicAuthorizationRule(
            javaResource as
                com.pulumi.azurenative.servicebus.TopicAuthorizationRule,
        )
}

/**
 * @see [TopicAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicAuthorizationRule].
 */
public suspend fun topicAuthorizationRule(
    name: String,
    block: suspend TopicAuthorizationRuleResourceBuilder.() -> Unit,
): TopicAuthorizationRule {
    val builder = TopicAuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicAuthorizationRule(name: String): TopicAuthorizationRule {
    val builder = TopicAuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
