@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of a namespace authorization rule.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### TopicAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topicAuthorizationRule = new AzureNative.ServiceBus.TopicAuthorizationRule("topicAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-AuthRules-4310",
 *         NamespaceName = "sdk-Namespace-6261",
 *         ResourceGroupName = "ArunMonocle",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *         TopicName = "sdk-Topics-1984",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewTopicAuthorizationRule(ctx, "topicAuthorizationRule", &servicebus.TopicAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-AuthRules-4310"),
 * 			NamespaceName:         pulumi.String("sdk-Namespace-6261"),
 * 			ResourceGroupName:     pulumi.String("ArunMonocle"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 			TopicName: pulumi.String("sdk-Topics-1984"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.TopicAuthorizationRule;
 * import com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topicAuthorizationRule = new TopicAuthorizationRule("topicAuthorizationRule", TopicAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-AuthRules-4310")
 *             .namespaceName("sdk-Namespace-6261")
 *             .resourceGroupName("ArunMonocle")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .topicName("sdk-Topics-1984")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:TopicAuthorizationRule sdk-AuthRules-4310 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rights The rights associated with the rule.
 * @property topicName The topic name.
 */
public data class TopicAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs =
        com.pulumi.azurenative.servicebus.TopicAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class TopicAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("xurudrlinsxbbilu")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("mldapgdqgudlmrjp")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("udnepapmhcbrftor")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("iywoothworrppdpa")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("ioqoniulebllwugq")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("ntrdukidgvpxanae")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The topic name.
     */
    @JvmName("jwblfdhogqtrhvow")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("dsnkfltkoibnykpd")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wohbjntwvtlpeaje")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hfcxittrngjjgoej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("wntmmnawtshsfgvr")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("dqehvljfasiuylpq")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("vkatdvghmkwoxpjj")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicAuthorizationRuleArgs = TopicAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        rights = rights,
        topicName = topicName,
    )
}
