@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties to configure Encryption
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 * @property requireInfrastructureEncryption Enable Infrastructure Encryption (Double Encryption)
 */
public data class EncryptionArgs(
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultProperties: Output<List<KeyVaultPropertiesArgs>>? = null,
    public val requireInfrastructureEncryption: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.EncryptionArgs =
        com.pulumi.azurenative.servicebus.inputs.EncryptionArgs.builder()
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requireInfrastructureEncryption(
                requireInfrastructureEncryption?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultProperties: Output<List<KeyVaultPropertiesArgs>>? = null

    private var requireInfrastructureEncryption: Output<Boolean>? = null

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("gusibjmfaepawhme")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("nvnymwqiuhuwxggo")
    public suspend fun keyVaultProperties(`value`: Output<List<KeyVaultPropertiesArgs>>) {
        this.keyVaultProperties = value
    }

    @JvmName("rhcprhnbvsgflcve")
    public suspend fun keyVaultProperties(vararg values: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = Output.all(values.asList())
    }

    /**
     * @param values Properties of KeyVault
     */
    @JvmName("ooqwulsovrfgwifh")
    public suspend fun keyVaultProperties(values: List<Output<KeyVaultPropertiesArgs>>) {
        this.keyVaultProperties = Output.all(values)
    }

    /**
     * @param value Enable Infrastructure Encryption (Double Encryption)
     */
    @JvmName("fxveuhopmxcqsdts")
    public suspend fun requireInfrastructureEncryption(`value`: Output<Boolean>) {
        this.requireInfrastructureEncryption = value
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("kylaxdcymxyieagc")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("mndcsoturysohsif")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("qqjandpjljmrukhe")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("urduaqirwpdbujja")
    public suspend fun keyVaultProperties(`value`: List<KeyVaultPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("cnmroungwlguqtcg")
    public suspend
    fun keyVaultProperties(argument: List<suspend KeyVaultPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KeyVaultPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("ydnquriuqjvqrvqd")
    public suspend fun keyVaultProperties(
        vararg
        argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KeyVaultPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("wulrvkorrbiogjcs")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param values Properties of KeyVault
     */
    @JvmName("goxkqemexmxofbjl")
    public suspend fun keyVaultProperties(vararg values: KeyVaultPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Enable Infrastructure Encryption (Double Encryption)
     */
    @JvmName("rekvirvsggqkwsqw")
    public suspend fun requireInfrastructureEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInfrastructureEncryption = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
        requireInfrastructureEncryption = requireInfrastructureEncryption,
    )
}
