@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.IdentityArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties to configure User Assigned Identities for Bring your Own Keys
 * @property type Type of managed service identity.
 * @property userAssignedIdentities Properties for User Assigned Identities
 */
public data class IdentityArgs(
    public val type: Output<Either<String, ManagedServiceIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.IdentityArgs =
        com.pulumi.azurenative.servicebus.inputs.IdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("ehvmbbjhvumtjwbr")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Properties for User Assigned Identities
     */
    @JvmName("olvqdslwudvevgla")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("hhvksbhvsejhliyu")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Properties for User Assigned Identities
     */
    @JvmName("jrandbnossbwwekq")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("imvgyrtulaqnlsfv")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("cnavlupvehfijqmf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("sivqchfoorfocucu")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Properties for User Assigned Identities
     */
    @JvmName("qyjunnuqbsvatvtp")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Properties for User Assigned Identities
     */
    @JvmName("ngogbiiujajdujoo")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
