@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents the correlation filter expression.
 * @property contentType Content type of the message.
 * @property correlationId Identifier of the correlation.
 * @property label Application specific label.
 * @property messageId Identifier of the message.
 * @property properties dictionary object for custom filters
 * @property replyTo Address of the queue to reply to.
 * @property replyToSessionId Session identifier to reply to.
 * @property requiresPreprocessing Value that indicates whether the rule action requires preprocessing.
 * @property sessionId Session identifier.
 * @property to Address to send to.
 */
public data class CorrelationFilterResponse(
    public val contentType: String? = null,
    public val correlationId: String? = null,
    public val label: String? = null,
    public val messageId: String? = null,
    public val properties: Map<String, String>? = null,
    public val replyTo: String? = null,
    public val replyToSessionId: String? = null,
    public val requiresPreprocessing: Boolean? = null,
    public val sessionId: String? = null,
    public val to: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.CorrelationFilterResponse):
            CorrelationFilterResponse = CorrelationFilterResponse(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            correlationId = javaType.correlationId().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            replyTo = javaType.replyTo().map({ args0 -> args0 }).orElse(null),
            replyToSessionId = javaType.replyToSessionId().map({ args0 -> args0 }).orElse(null),
            requiresPreprocessing = javaType.requiresPreprocessing().map({ args0 -> args0 }).orElse(null),
            sessionId = javaType.sessionId().map({ args0 -> args0 }).orElse(null),
            to = javaType.to().map({ args0 -> args0 }).orElse(null),
        )
    }
}
