@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ManagedClusterArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.ClusterUpgradeCadence
import com.pulumi.azurenative.servicefabric.kotlin.enums.ClusterUpgradeMode
import com.pulumi.azurenative.servicefabric.kotlin.enums.ManagedClusterAddOnFeature
import com.pulumi.azurenative.servicefabric.kotlin.enums.ZonalUpdateMode
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationTypeVersionsCleanupPolicyArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationTypeVersionsCleanupPolicyArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.AzureActiveDirectoryArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.AzureActiveDirectoryArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ClientCertificateArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ClientCertificateArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.IPTagArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.IPTagArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.LoadBalancingRuleArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.LoadBalancingRuleArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NetworkSecurityRuleArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NetworkSecurityRuleArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ServiceEndpointArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ServiceEndpointArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SettingsSectionDescriptionArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SettingsSectionDescriptionArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The managed cluster resource
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2020-01-01-preview, 2022-01-01, 2022-10-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Put a cluster with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ServiceFabric.ManagedCluster("managedCluster", new()
 *     {
 *         AddonFeatures = new[]
 *         {
 *             "DnsService",
 *             "BackupRestoreService",
 *             "ResourceMonitorService",
 *         },
 *         AdminPassword = "{vm-password}",
 *         AdminUserName = "vmadmin",
 *         AllowRdpAccess = true,
 *         ApplicationTypeVersionsCleanupPolicy = new AzureNative.ServiceFabric.Inputs.ApplicationTypeVersionsCleanupPolicyArgs
 *         {
 *             MaxUnusedVersionsToKeep = 3,
 *         },
 *         AuxiliarySubnets = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.SubnetArgs
 *             {
 *                 EnableIpv6 = true,
 *                 Name = "testSubnet1",
 *                 NetworkSecurityGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/networkSecurityGroups/sn1",
 *                 PrivateEndpointNetworkPolicies = "enabled",
 *                 PrivateLinkServiceNetworkPolicies = "enabled",
 *             },
 *         },
 *         ClientConnectionPort = 19000,
 *         ClusterCodeVersion = "7.1.168.9494",
 *         ClusterName = "myCluster",
 *         ClusterUpgradeMode = "Manual",
 *         DnsName = "myCluster",
 *         EnableAutoOSUpgrade = true,
 *         EnableIpv6 = true,
 *         FabricSettings = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.SettingsSectionDescriptionArgs
 *             {
 *                 Name = "ManagedIdentityTokenService",
 *                 Parameters = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.SettingsParameterDescriptionArgs
 *                     {
 *                         Name = "IsEnabled",
 *                         Value = "true",
 *                     },
 *                 },
 *             },
 *         },
 *         HttpGatewayConnectionPort = 19080,
 *         IpTags = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.IPTagArgs
 *             {
 *                 IpTagType = "FirstPartyUsage",
 *                 Tag = "SQL",
 *             },
 *         },
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendPort = 80,
 *                 FrontendPort = 80,
 *                 ProbePort = 80,
 *                 ProbeProtocol = "http",
 *                 Protocol = "http",
 *             },
 *             new AzureNative.ServiceFabric.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendPort = 443,
 *                 FrontendPort = 443,
 *                 ProbePort = 443,
 *                 ProbeProtocol = "http",
 *                 Protocol = "http",
 *             },
 *             new AzureNative.ServiceFabric.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendPort = 10000,
 *                 FrontendPort = 10000,
 *                 LoadDistribution = "Default",
 *                 ProbePort = 10000,
 *                 ProbeProtocol = "http",
 *                 Protocol = "tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkSecurityRules = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.NetworkSecurityRuleArgs
 *             {
 *                 Access = "allow",
 *                 Description = "Test description",
 *                 DestinationAddressPrefixes = new[]
 *                 {
 *                     "*",
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     "*",
 *                 },
 *                 Direction = "inbound",
 *                 Name = "TestName",
 *                 Priority = 1010,
 *                 Protocol = "tcp",
 *                 SourceAddressPrefixes = new[]
 *                 {
 *                     "*",
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new AzureNative.ServiceFabric.Inputs.NetworkSecurityRuleArgs
 *             {
 *                 Access = "allow",
 *                 DestinationAddressPrefix = "*",
 *                 DestinationPortRange = "33500-33699",
 *                 Direction = "inbound",
 *                 Name = "AllowARM",
 *                 Priority = 2002,
 *                 Protocol = "*",
 *                 SourceAddressPrefix = "AzureResourceManager",
 *                 SourcePortRange = "*",
 *             },
 *         },
 *         PublicIPPrefixId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.Network/publicIPPrefixes/myPublicIPPrefix",
 *         ResourceGroupName = "resRg",
 *         ServiceEndpoints = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.ServiceEndpointArgs
 *             {
 *                 Locations = new[]
 *                 {
 *                     "eastus2",
 *                     "usnorth",
 *                 },
 *                 Service = "Microsoft.Storage",
 *             },
 *         },
 *         Sku = new AzureNative.ServiceFabric.Inputs.SkuArgs
 *         {
 *             Name = "Basic",
 *         },
 *         Tags = null,
 *         UseCustomVnet = true,
 *         ZonalResiliency = true,
 *         ZonalUpdateMode = "Fast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedCluster(ctx, "managedCluster", &servicefabric.ManagedClusterArgs{
 * 			AddonFeatures: pulumi.StringArray{
 * 				pulumi.String("DnsService"),
 * 				pulumi.String("BackupRestoreService"),
 * 				pulumi.String("ResourceMonitorService"),
 * 			},
 * 			AdminPassword:  pulumi.String("{vm-password}"),
 * 			AdminUserName:  pulumi.String("vmadmin"),
 * 			AllowRdpAccess: pulumi.Bool(true),
 * 			ApplicationTypeVersionsCleanupPolicy: &servicefabric.ApplicationTypeVersionsCleanupPolicyArgs{
 * 				MaxUnusedVersionsToKeep: pulumi.Int(3),
 * 			},
 * 			AuxiliarySubnets: []servicefabric.SubnetArgs{
 * 				{
 * 					EnableIpv6:                        pulumi.Bool(true),
 * 					Name:                              pulumi.String("testSubnet1"),
 * 					NetworkSecurityGroupId:            pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/networkSecurityGroups/sn1"),
 * 					PrivateEndpointNetworkPolicies:    pulumi.String("enabled"),
 * 					PrivateLinkServiceNetworkPolicies: pulumi.String("enabled"),
 * 				},
 * 			},
 * 			ClientConnectionPort: pulumi.Int(19000),
 * 			ClusterCodeVersion:   pulumi.String("7.1.168.9494"),
 * 			ClusterName:          pulumi.String("myCluster"),
 * 			ClusterUpgradeMode:   pulumi.String("Manual"),
 * 			DnsName:              pulumi.String("myCluster"),
 * 			EnableAutoOSUpgrade:  pulumi.Bool(true),
 * 			EnableIpv6:           pulumi.Bool(true),
 * 			FabricSettings: []servicefabric.SettingsSectionDescriptionArgs{
 * 				{
 * 					Name: pulumi.String("ManagedIdentityTokenService"),
 * 					Parameters: servicefabric.SettingsParameterDescriptionArray{
 * 						{
 * 							Name:  pulumi.String("IsEnabled"),
 * 							Value: pulumi.String("true"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			HttpGatewayConnectionPort: pulumi.Int(19080),
 * 			IpTags: []servicefabric.IPTagArgs{
 * 				{
 * 					IpTagType: pulumi.String("FirstPartyUsage"),
 * 					Tag:       pulumi.String("SQL"),
 * 				},
 * 			},
 * 			LoadBalancingRules: []servicefabric.LoadBalancingRuleArgs{
 * 				{
 * 					BackendPort:   pulumi.Int(80),
 * 					FrontendPort:  pulumi.Int(80),
 * 					ProbePort:     pulumi.Int(80),
 * 					ProbeProtocol: pulumi.String("http"),
 * 					Protocol:      pulumi.String("http"),
 * 				},
 * 				{
 * 					BackendPort:   pulumi.Int(443),
 * 					FrontendPort:  pulumi.Int(443),
 * 					ProbePort:     pulumi.Int(443),
 * 					ProbeProtocol: pulumi.String("http"),
 * 					Protocol:      pulumi.String("http"),
 * 				},
 * 				{
 * 					BackendPort:      pulumi.Int(10000),
 * 					FrontendPort:     pulumi.Int(10000),
 * 					LoadDistribution: pulumi.String("Default"),
 * 					ProbePort:        pulumi.Int(10000),
 * 					ProbeProtocol:    pulumi.String("http"),
 * 					Protocol:         pulumi.String("tcp"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NetworkSecurityRules: []servicefabric.NetworkSecurityRuleArgs{
 * 				{
 * 					Access:      pulumi.String("allow"),
 * 					Description: pulumi.String("Test description"),
 * 					DestinationAddressPrefixes: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					DestinationPortRanges: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					Direction: pulumi.String("inbound"),
 * 					Name:      pulumi.String("TestName"),
 * 					Priority:  pulumi.Int(1010),
 * 					Protocol:  pulumi.String("tcp"),
 * 					SourceAddressPrefixes: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					SourcePortRanges: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				{
 * 					Access:                   pulumi.String("allow"),
 * 					DestinationAddressPrefix: pulumi.String("*"),
 * 					DestinationPortRange:     pulumi.String("33500-33699"),
 * 					Direction:                pulumi.String("inbound"),
 * 					Name:                     pulumi.String("AllowARM"),
 * 					Priority:                 pulumi.Int(2002),
 * 					Protocol:                 pulumi.String("*"),
 * 					SourceAddressPrefix:      pulumi.String("AzureResourceManager"),
 * 					SourcePortRange:          pulumi.String("*"),
 * 				},
 * 			},
 * 			PublicIPPrefixId:  pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.Network/publicIPPrefixes/myPublicIPPrefix"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ServiceEndpoints: []servicefabric.ServiceEndpointArgs{
 * 				{
 * 					Locations: pulumi.StringArray{
 * 						pulumi.String("eastus2"),
 * 						pulumi.String("usnorth"),
 * 					},
 * 					Service: pulumi.String("Microsoft.Storage"),
 * 				},
 * 			},
 * 			Sku: &servicefabric.SkuArgs{
 * 				Name: pulumi.String("Basic"),
 * 			},
 * 			Tags:            nil,
 * 			UseCustomVnet:   pulumi.Bool(true),
 * 			ZonalResiliency: pulumi.Bool(true),
 * 			ZonalUpdateMode: pulumi.String("Fast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedCluster;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonFeatures(
 *                 "DnsService",
 *                 "BackupRestoreService",
 *                 "ResourceMonitorService")
 *             .adminPassword("{vm-password}")
 *             .adminUserName("vmadmin")
 *             .allowRdpAccess(true)
 *             .applicationTypeVersionsCleanupPolicy(Map.of("maxUnusedVersionsToKeep", 3))
 *             .auxiliarySubnets(Map.ofEntries(
 *                 Map.entry("enableIpv6", true),
 *                 Map.entry("name", "testSubnet1"),
 *                 Map.entry("networkSecurityGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/networkSecurityGroups/sn1"),
 *                 Map.entry("privateEndpointNetworkPolicies", "enabled"),
 *                 Map.entry("privateLinkServiceNetworkPolicies", "enabled")
 *             ))
 *             .clientConnectionPort(19000)
 *             .clusterCodeVersion("7.1.168.9494")
 *             .clusterName("myCluster")
 *             .clusterUpgradeMode("Manual")
 *             .dnsName("myCluster")
 *             .enableAutoOSUpgrade(true)
 *             .enableIpv6(true)
 *             .fabricSettings(Map.ofEntries(
 *                 Map.entry("name", "ManagedIdentityTokenService"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("name", "IsEnabled"),
 *                     Map.entry("value", "true")
 *                 ))
 *             ))
 *             .httpGatewayConnectionPort(19080)
 *             .ipTags(Map.ofEntries(
 *                 Map.entry("ipTagType", "FirstPartyUsage"),
 *                 Map.entry("tag", "SQL")
 *             ))
 *             .loadBalancingRules(
 *                 Map.ofEntries(
 *                     Map.entry("backendPort", 80),
 *                     Map.entry("frontendPort", 80),
 *                     Map.entry("probePort", 80),
 *                     Map.entry("probeProtocol", "http"),
 *                     Map.entry("protocol", "http")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("backendPort", 443),
 *                     Map.entry("frontendPort", 443),
 *                     Map.entry("probePort", 443),
 *                     Map.entry("probeProtocol", "http"),
 *                     Map.entry("protocol", "http")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("backendPort", 10000),
 *                     Map.entry("frontendPort", 10000),
 *                     Map.entry("loadDistribution", "Default"),
 *                     Map.entry("probePort", 10000),
 *                     Map.entry("probeProtocol", "http"),
 *                     Map.entry("protocol", "tcp")
 *                 ))
 *             .location("eastus")
 *             .networkSecurityRules(
 *                 Map.ofEntries(
 *                     Map.entry("access", "allow"),
 *                     Map.entry("description", "Test description"),
 *                     Map.entry("destinationAddressPrefixes", "*"),
 *                     Map.entry("destinationPortRanges", "*"),
 *                     Map.entry("direction", "inbound"),
 *                     Map.entry("name", "TestName"),
 *                     Map.entry("priority", 1010),
 *                     Map.entry("protocol", "tcp"),
 *                     Map.entry("sourceAddressPrefixes", "*"),
 *                     Map.entry("sourcePortRanges", "*")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("access", "allow"),
 *                     Map.entry("destinationAddressPrefix", "*"),
 *                     Map.entry("destinationPortRange", "33500-33699"),
 *                     Map.entry("direction", "inbound"),
 *                     Map.entry("name", "AllowARM"),
 *                     Map.entry("priority", 2002),
 *                     Map.entry("protocol", "*"),
 *                     Map.entry("sourceAddressPrefix", "AzureResourceManager"),
 *                     Map.entry("sourcePortRange", "*")
 *                 ))
 *             .publicIPPrefixId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.Network/publicIPPrefixes/myPublicIPPrefix")
 *             .resourceGroupName("resRg")
 *             .serviceEndpoints(Map.ofEntries(
 *                 Map.entry("locations",
 *                     "eastus2",
 *                     "usnorth"),
 *                 Map.entry("service", "Microsoft.Storage")
 *             ))
 *             .sku(Map.of("name", "Basic"))
 *             .tags()
 *             .useCustomVnet(true)
 *             .zonalResiliency(true)
 *             .zonalUpdateMode("Fast")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a cluster with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ServiceFabric.ManagedCluster("managedCluster", new()
 *     {
 *         AdminPassword = "{vm-password}",
 *         AdminUserName = "vmadmin",
 *         ClusterName = "myCluster",
 *         ClusterUpgradeCadence = "Wave1",
 *         ClusterUpgradeMode = "Automatic",
 *         DnsName = "myCluster",
 *         FabricSettings = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.SettingsSectionDescriptionArgs
 *             {
 *                 Name = "ManagedIdentityTokenService",
 *                 Parameters = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.SettingsParameterDescriptionArgs
 *                     {
 *                         Name = "IsEnabled",
 *                         Value = "true",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *         Sku = new AzureNative.ServiceFabric.Inputs.SkuArgs
 *         {
 *             Name = "Basic",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedCluster(ctx, "managedCluster", &servicefabric.ManagedClusterArgs{
 * 			AdminPassword:         pulumi.String("{vm-password}"),
 * 			AdminUserName:         pulumi.String("vmadmin"),
 * 			ClusterName:           pulumi.String("myCluster"),
 * 			ClusterUpgradeCadence: pulumi.String("Wave1"),
 * 			ClusterUpgradeMode:    pulumi.String("Automatic"),
 * 			DnsName:               pulumi.String("myCluster"),
 * 			FabricSettings: []servicefabric.SettingsSectionDescriptionArgs{
 * 				{
 * 					Name: pulumi.String("ManagedIdentityTokenService"),
 * 					Parameters: servicefabric.SettingsParameterDescriptionArray{
 * 						{
 * 							Name:  pulumi.String("IsEnabled"),
 * 							Value: pulumi.String("true"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			Sku: &servicefabric.SkuArgs{
 * 				Name: pulumi.String("Basic"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedCluster;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .adminPassword("{vm-password}")
 *             .adminUserName("vmadmin")
 *             .clusterName("myCluster")
 *             .clusterUpgradeCadence("Wave1")
 *             .clusterUpgradeMode("Automatic")
 *             .dnsName("myCluster")
 *             .fabricSettings(Map.ofEntries(
 *                 Map.entry("name", "ManagedIdentityTokenService"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("name", "IsEnabled"),
 *                     Map.entry("value", "true")
 *                 ))
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .sku(Map.of("name", "Basic"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedCluster myCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedClusters/{clusterName}
 * ```
 * @property addonFeatures List of add-on features to enable on the cluster.
 * @property adminPassword VM admin user password.
 * @property adminUserName VM admin user name.
 * @property allowRdpAccess Setting this to true enables RDP access to the VM. The default NSG rule opens RDP port to Internet which can be overridden with custom Network Security Rules. The default value for this setting is false.
 * @property applicationTypeVersionsCleanupPolicy The policy used to clean up unused versions.
 * @property auxiliarySubnets Auxiliary subnets for the cluster.
 * @property azureActiveDirectory The AAD authentication settings of the cluster.
 * @property clientConnectionPort The port used for client connections to the cluster.
 * @property clients Client certificates that are allowed to manage the cluster.
 * @property clusterCodeVersion The Service Fabric runtime version of the cluster. This property is required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
 * @property clusterName The name of the cluster resource.
 * @property clusterUpgradeCadence Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
 * @property clusterUpgradeMode The upgrade mode of the cluster when new Service Fabric runtime version is available.
 * @property dnsName The cluster dns name.
 * @property enableAutoOSUpgrade Setting this to true enables automatic OS upgrade for the node types that are created using any platform OS image with version 'latest'. The default value for this setting is false.
 * @property enableIpv6 Setting this to true creates IPv6 address space for the default VNet used by the cluster. This setting cannot be changed once the cluster is created. The default value for this setting is false.
 * @property enableServicePublicIP Setting this to true will link the IPv4 address as the ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the cluster.
 * @property fabricSettings The list of custom fabric settings to configure the cluster.
 * @property httpGatewayConnectionPort The port used for HTTP connections to the cluster.
 * @property ipTags The list of IP tags associated with the default public IP address of the cluster.
 * @property loadBalancingRules Load balancing rules that are applied to the public load balancer of the cluster.
 * @property location Azure resource location.
 * @property networkSecurityRules Custom Network Security Rules that are applied to the Virtual Network of the cluster.
 * @property publicIPPrefixId Specify the resource id of a public IP prefix that the load balancer will allocate a public IP address from. Only supports IPv4.
 * @property resourceGroupName The name of the resource group.
 * @property serviceEndpoints Service endpoints for subnets in the cluster.
 * @property sku The sku of the managed cluster
 * @property subnetId If specified, the node types for the cluster are created in this subnet instead of the default VNet. The **networkSecurityRules** specified for the cluster are also applied to this subnet. This setting cannot be changed once the cluster is created.
 * @property tags Azure resource tags.
 * @property useCustomVnet For new clusters, this parameter indicates that it uses Bring your own VNet, but the subnet is specified at node type level; and for such clusters, the subnetId property is required for node types.
 * @property zonalResiliency Indicates if the cluster has zone resiliency.
 * @property zonalUpdateMode Indicates the update mode for Cross Az clusters.
 */
public data class ManagedClusterArgs(
    public val addonFeatures: Output<List<Either<String, ManagedClusterAddOnFeature>>>? = null,
    public val adminPassword: Output<String>? = null,
    public val adminUserName: Output<String>? = null,
    public val allowRdpAccess: Output<Boolean>? = null,
    public val applicationTypeVersionsCleanupPolicy: Output<ApplicationTypeVersionsCleanupPolicyArgs>? =
        null,
    public val auxiliarySubnets: Output<List<SubnetArgs>>? = null,
    public val azureActiveDirectory: Output<AzureActiveDirectoryArgs>? = null,
    public val clientConnectionPort: Output<Int>? = null,
    public val clients: Output<List<ClientCertificateArgs>>? = null,
    public val clusterCodeVersion: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterUpgradeCadence: Output<Either<String, ClusterUpgradeCadence>>? = null,
    public val clusterUpgradeMode: Output<Either<String, ClusterUpgradeMode>>? = null,
    public val dnsName: Output<String>? = null,
    public val enableAutoOSUpgrade: Output<Boolean>? = null,
    public val enableIpv6: Output<Boolean>? = null,
    public val enableServicePublicIP: Output<Boolean>? = null,
    public val fabricSettings: Output<List<SettingsSectionDescriptionArgs>>? = null,
    public val httpGatewayConnectionPort: Output<Int>? = null,
    public val ipTags: Output<List<IPTagArgs>>? = null,
    public val loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val networkSecurityRules: Output<List<NetworkSecurityRuleArgs>>? = null,
    public val publicIPPrefixId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceEndpoints: Output<List<ServiceEndpointArgs>>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useCustomVnet: Output<Boolean>? = null,
    public val zonalResiliency: Output<Boolean>? = null,
    public val zonalUpdateMode: Output<Either<String, ZonalUpdateMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.ManagedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.ManagedClusterArgs =
        com.pulumi.azurenative.servicefabric.ManagedClusterArgs.builder()
            .addonFeatures(
                addonFeatures?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUserName(adminUserName?.applyValue({ args0 -> args0 }))
            .allowRdpAccess(allowRdpAccess?.applyValue({ args0 -> args0 }))
            .applicationTypeVersionsCleanupPolicy(
                applicationTypeVersionsCleanupPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .auxiliarySubnets(
                auxiliarySubnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .azureActiveDirectory(
                azureActiveDirectory?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientConnectionPort(clientConnectionPort?.applyValue({ args0 -> args0 }))
            .clients(
                clients?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .clusterCodeVersion(clusterCodeVersion?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterUpgradeCadence(
                clusterUpgradeCadence?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .clusterUpgradeMode(
                clusterUpgradeMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dnsName(dnsName?.applyValue({ args0 -> args0 }))
            .enableAutoOSUpgrade(enableAutoOSUpgrade?.applyValue({ args0 -> args0 }))
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .enableServicePublicIP(enableServicePublicIP?.applyValue({ args0 -> args0 }))
            .fabricSettings(
                fabricSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .httpGatewayConnectionPort(httpGatewayConnectionPort?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .loadBalancingRules(
                loadBalancingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkSecurityRules(
                networkSecurityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicIPPrefixId(publicIPPrefixId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceEndpoints(
                serviceEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useCustomVnet(useCustomVnet?.applyValue({ args0 -> args0 }))
            .zonalResiliency(zonalResiliency?.applyValue({ args0 -> args0 }))
            .zonalUpdateMode(
                zonalUpdateMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterArgs].
 */
@PulumiTagMarker
public class ManagedClusterArgsBuilder internal constructor() {
    private var addonFeatures: Output<List<Either<String, ManagedClusterAddOnFeature>>>? = null

    private var adminPassword: Output<String>? = null

    private var adminUserName: Output<String>? = null

    private var allowRdpAccess: Output<Boolean>? = null

    private var applicationTypeVersionsCleanupPolicy:
        Output<ApplicationTypeVersionsCleanupPolicyArgs>? = null

    private var auxiliarySubnets: Output<List<SubnetArgs>>? = null

    private var azureActiveDirectory: Output<AzureActiveDirectoryArgs>? = null

    private var clientConnectionPort: Output<Int>? = null

    private var clients: Output<List<ClientCertificateArgs>>? = null

    private var clusterCodeVersion: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var clusterUpgradeCadence: Output<Either<String, ClusterUpgradeCadence>>? = null

    private var clusterUpgradeMode: Output<Either<String, ClusterUpgradeMode>>? = null

    private var dnsName: Output<String>? = null

    private var enableAutoOSUpgrade: Output<Boolean>? = null

    private var enableIpv6: Output<Boolean>? = null

    private var enableServicePublicIP: Output<Boolean>? = null

    private var fabricSettings: Output<List<SettingsSectionDescriptionArgs>>? = null

    private var httpGatewayConnectionPort: Output<Int>? = null

    private var ipTags: Output<List<IPTagArgs>>? = null

    private var loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null

    private var location: Output<String>? = null

    private var networkSecurityRules: Output<List<NetworkSecurityRuleArgs>>? = null

    private var publicIPPrefixId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceEndpoints: Output<List<ServiceEndpointArgs>>? = null

    private var sku: Output<SkuArgs>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useCustomVnet: Output<Boolean>? = null

    private var zonalResiliency: Output<Boolean>? = null

    private var zonalUpdateMode: Output<Either<String, ZonalUpdateMode>>? = null

    /**
     * @param value List of add-on features to enable on the cluster.
     */
    @JvmName("qrmaiwiphroqxbof")
    public suspend
    fun addonFeatures(`value`: Output<List<Either<String, ManagedClusterAddOnFeature>>>) {
        this.addonFeatures = value
    }

    @JvmName("brjnhijglylpfaoj")
    public suspend fun addonFeatures(
        vararg
        values: Output<Either<String, ManagedClusterAddOnFeature>>,
    ) {
        this.addonFeatures = Output.all(values.asList())
    }

    /**
     * @param values List of add-on features to enable on the cluster.
     */
    @JvmName("auugnijpqsfxtwvw")
    public suspend
    fun addonFeatures(values: List<Output<Either<String, ManagedClusterAddOnFeature>>>) {
        this.addonFeatures = Output.all(values)
    }

    /**
     * @param value VM admin user password.
     */
    @JvmName("erxuwqkixxxcynpc")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value VM admin user name.
     */
    @JvmName("ueoclllylpvphljh")
    public suspend fun adminUserName(`value`: Output<String>) {
        this.adminUserName = value
    }

    /**
     * @param value Setting this to true enables RDP access to the VM. The default NSG rule opens RDP port to Internet which can be overridden with custom Network Security Rules. The default value for this setting is false.
     */
    @JvmName("uoxhgxslimikwshc")
    public suspend fun allowRdpAccess(`value`: Output<Boolean>) {
        this.allowRdpAccess = value
    }

    /**
     * @param value The policy used to clean up unused versions.
     */
    @JvmName("bsaothgcrcdsinli")
    public suspend
    fun applicationTypeVersionsCleanupPolicy(`value`: Output<ApplicationTypeVersionsCleanupPolicyArgs>) {
        this.applicationTypeVersionsCleanupPolicy = value
    }

    /**
     * @param value Auxiliary subnets for the cluster.
     */
    @JvmName("ahellxowjggegabr")
    public suspend fun auxiliarySubnets(`value`: Output<List<SubnetArgs>>) {
        this.auxiliarySubnets = value
    }

    @JvmName("wsrfwnwlmuiplvjo")
    public suspend fun auxiliarySubnets(vararg values: Output<SubnetArgs>) {
        this.auxiliarySubnets = Output.all(values.asList())
    }

    /**
     * @param values Auxiliary subnets for the cluster.
     */
    @JvmName("dsenkjfniloiuhvs")
    public suspend fun auxiliarySubnets(values: List<Output<SubnetArgs>>) {
        this.auxiliarySubnets = Output.all(values)
    }

    /**
     * @param value The AAD authentication settings of the cluster.
     */
    @JvmName("wgfmyjuhxojobvsx")
    public suspend fun azureActiveDirectory(`value`: Output<AzureActiveDirectoryArgs>) {
        this.azureActiveDirectory = value
    }

    /**
     * @param value The port used for client connections to the cluster.
     */
    @JvmName("bigimwnvfjebfeyv")
    public suspend fun clientConnectionPort(`value`: Output<Int>) {
        this.clientConnectionPort = value
    }

    /**
     * @param value Client certificates that are allowed to manage the cluster.
     */
    @JvmName("cfddeumvsnrkkfdy")
    public suspend fun clients(`value`: Output<List<ClientCertificateArgs>>) {
        this.clients = value
    }

    @JvmName("uhtrmnswjilxrrew")
    public suspend fun clients(vararg values: Output<ClientCertificateArgs>) {
        this.clients = Output.all(values.asList())
    }

    /**
     * @param values Client certificates that are allowed to manage the cluster.
     */
    @JvmName("ajbephubcphkdeft")
    public suspend fun clients(values: List<Output<ClientCertificateArgs>>) {
        this.clients = Output.all(values)
    }

    /**
     * @param value The Service Fabric runtime version of the cluster. This property is required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
     */
    @JvmName("iyaqhrjkrdmikpym")
    public suspend fun clusterCodeVersion(`value`: Output<String>) {
        this.clusterCodeVersion = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("jpcvknvokacivdby")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
     */
    @JvmName("mjjeqicpstytukix")
    public suspend fun clusterUpgradeCadence(`value`: Output<Either<String, ClusterUpgradeCadence>>) {
        this.clusterUpgradeCadence = value
    }

    /**
     * @param value The upgrade mode of the cluster when new Service Fabric runtime version is available.
     */
    @JvmName("iigirssbraajalyp")
    public suspend fun clusterUpgradeMode(`value`: Output<Either<String, ClusterUpgradeMode>>) {
        this.clusterUpgradeMode = value
    }

    /**
     * @param value The cluster dns name.
     */
    @JvmName("iufrwvmopvwpseij")
    public suspend fun dnsName(`value`: Output<String>) {
        this.dnsName = value
    }

    /**
     * @param value Setting this to true enables automatic OS upgrade for the node types that are created using any platform OS image with version 'latest'. The default value for this setting is false.
     */
    @JvmName("nlbveylolsbsljnb")
    public suspend fun enableAutoOSUpgrade(`value`: Output<Boolean>) {
        this.enableAutoOSUpgrade = value
    }

    /**
     * @param value Setting this to true creates IPv6 address space for the default VNet used by the cluster. This setting cannot be changed once the cluster is created. The default value for this setting is false.
     */
    @JvmName("edpebvfmbculvxsl")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value Setting this to true will link the IPv4 address as the ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the cluster.
     */
    @JvmName("vwbxasycslcvfqjb")
    public suspend fun enableServicePublicIP(`value`: Output<Boolean>) {
        this.enableServicePublicIP = value
    }

    /**
     * @param value The list of custom fabric settings to configure the cluster.
     */
    @JvmName("hivqcgrfjgcukofl")
    public suspend fun fabricSettings(`value`: Output<List<SettingsSectionDescriptionArgs>>) {
        this.fabricSettings = value
    }

    @JvmName("efnkpdcwgshyfeqn")
    public suspend fun fabricSettings(vararg values: Output<SettingsSectionDescriptionArgs>) {
        this.fabricSettings = Output.all(values.asList())
    }

    /**
     * @param values The list of custom fabric settings to configure the cluster.
     */
    @JvmName("ejjjgdeaupmwlxrt")
    public suspend fun fabricSettings(values: List<Output<SettingsSectionDescriptionArgs>>) {
        this.fabricSettings = Output.all(values)
    }

    /**
     * @param value The port used for HTTP connections to the cluster.
     */
    @JvmName("ojnugoyfhlsfvtxf")
    public suspend fun httpGatewayConnectionPort(`value`: Output<Int>) {
        this.httpGatewayConnectionPort = value
    }

    /**
     * @param value The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("gcmjcjeyuruebwys")
    public suspend fun ipTags(`value`: Output<List<IPTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("yoasewwvvwfkgemt")
    public suspend fun ipTags(vararg values: Output<IPTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("ausyvqsiavecljen")
    public suspend fun ipTags(values: List<Output<IPTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("okoavfwhmjgnntgw")
    public suspend fun loadBalancingRules(`value`: Output<List<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = value
    }

    @JvmName("tvtniwrsqudvgpbh")
    public suspend fun loadBalancingRules(vararg values: Output<LoadBalancingRuleArgs>) {
        this.loadBalancingRules = Output.all(values.asList())
    }

    /**
     * @param values Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("yyxfxqyacitakwux")
    public suspend fun loadBalancingRules(values: List<Output<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = Output.all(values)
    }

    /**
     * @param value Azure resource location.
     */
    @JvmName("commrpyfsqrxrkoy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("uhivhkwiepyxovrd")
    public suspend fun networkSecurityRules(`value`: Output<List<NetworkSecurityRuleArgs>>) {
        this.networkSecurityRules = value
    }

    @JvmName("naxyndlfkwvicfiu")
    public suspend fun networkSecurityRules(vararg values: Output<NetworkSecurityRuleArgs>) {
        this.networkSecurityRules = Output.all(values.asList())
    }

    /**
     * @param values Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("hnjjmmebtslqkloa")
    public suspend fun networkSecurityRules(values: List<Output<NetworkSecurityRuleArgs>>) {
        this.networkSecurityRules = Output.all(values)
    }

    /**
     * @param value Specify the resource id of a public IP prefix that the load balancer will allocate a public IP address from. Only supports IPv4.
     */
    @JvmName("wngysxqqrkvodofa")
    public suspend fun publicIPPrefixId(`value`: Output<String>) {
        this.publicIPPrefixId = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yjpdypopgwxnjhna")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Service endpoints for subnets in the cluster.
     */
    @JvmName("thcdxangsfiqwmia")
    public suspend fun serviceEndpoints(`value`: Output<List<ServiceEndpointArgs>>) {
        this.serviceEndpoints = value
    }

    @JvmName("nrceubmdfmltvlky")
    public suspend fun serviceEndpoints(vararg values: Output<ServiceEndpointArgs>) {
        this.serviceEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Service endpoints for subnets in the cluster.
     */
    @JvmName("hdsatmybnryuqdpb")
    public suspend fun serviceEndpoints(values: List<Output<ServiceEndpointArgs>>) {
        this.serviceEndpoints = Output.all(values)
    }

    /**
     * @param value The sku of the managed cluster
     */
    @JvmName("kswwqsutqxmjfoar")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value If specified, the node types for the cluster are created in this subnet instead of the default VNet. The **networkSecurityRules** specified for the cluster are also applied to this subnet. This setting cannot be changed once the cluster is created.
     */
    @JvmName("blpqpntvkeeffucm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("nohelpidnpedcusq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value For new clusters, this parameter indicates that it uses Bring your own VNet, but the subnet is specified at node type level; and for such clusters, the subnetId property is required for node types.
     */
    @JvmName("klsfweriljeuvsrb")
    public suspend fun useCustomVnet(`value`: Output<Boolean>) {
        this.useCustomVnet = value
    }

    /**
     * @param value Indicates if the cluster has zone resiliency.
     */
    @JvmName("qtusfiqmdlrgkfxy")
    public suspend fun zonalResiliency(`value`: Output<Boolean>) {
        this.zonalResiliency = value
    }

    /**
     * @param value Indicates the update mode for Cross Az clusters.
     */
    @JvmName("giuglphtalqeyvys")
    public suspend fun zonalUpdateMode(`value`: Output<Either<String, ZonalUpdateMode>>) {
        this.zonalUpdateMode = value
    }

    /**
     * @param value List of add-on features to enable on the cluster.
     */
    @JvmName("dtqojanihpytkuxa")
    public suspend fun addonFeatures(`value`: List<Either<String, ManagedClusterAddOnFeature>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonFeatures = mapped
    }

    /**
     * @param values List of add-on features to enable on the cluster.
     */
    @JvmName("eappbsregufwboen")
    public suspend fun addonFeatures(vararg values: Either<String, ManagedClusterAddOnFeature>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonFeatures = mapped
    }

    /**
     * @param value VM admin user password.
     */
    @JvmName("wslahklsjqolhtyx")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value VM admin user name.
     */
    @JvmName("hywxodcavbifurqa")
    public suspend fun adminUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserName = mapped
    }

    /**
     * @param value Setting this to true enables RDP access to the VM. The default NSG rule opens RDP port to Internet which can be overridden with custom Network Security Rules. The default value for this setting is false.
     */
    @JvmName("lfbxmgphpkmvoyrx")
    public suspend fun allowRdpAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRdpAccess = mapped
    }

    /**
     * @param value The policy used to clean up unused versions.
     */
    @JvmName("gxupuchcjeyraoyc")
    public suspend
    fun applicationTypeVersionsCleanupPolicy(`value`: ApplicationTypeVersionsCleanupPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationTypeVersionsCleanupPolicy = mapped
    }

    /**
     * @param argument The policy used to clean up unused versions.
     */
    @JvmName("yxllaydhssamasvu")
    public suspend
    fun applicationTypeVersionsCleanupPolicy(argument: suspend ApplicationTypeVersionsCleanupPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationTypeVersionsCleanupPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.applicationTypeVersionsCleanupPolicy = mapped
    }

    /**
     * @param value Auxiliary subnets for the cluster.
     */
    @JvmName("vykmcfgtkbsxbvvb")
    public suspend fun auxiliarySubnets(`value`: List<SubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliarySubnets = mapped
    }

    /**
     * @param argument Auxiliary subnets for the cluster.
     */
    @JvmName("ehntkaqykxipyrnw")
    public suspend fun auxiliarySubnets(argument: List<suspend SubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auxiliarySubnets = mapped
    }

    /**
     * @param argument Auxiliary subnets for the cluster.
     */
    @JvmName("uqvsinjqhbxihnee")
    public suspend fun auxiliarySubnets(vararg argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auxiliarySubnets = mapped
    }

    /**
     * @param argument Auxiliary subnets for the cluster.
     */
    @JvmName("dqlckcfvarpaissh")
    public suspend fun auxiliarySubnets(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auxiliarySubnets = mapped
    }

    /**
     * @param values Auxiliary subnets for the cluster.
     */
    @JvmName("ggvyvrujrxjhsbkg")
    public suspend fun auxiliarySubnets(vararg values: SubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliarySubnets = mapped
    }

    /**
     * @param value The AAD authentication settings of the cluster.
     */
    @JvmName("igfxuqshiroqavgi")
    public suspend fun azureActiveDirectory(`value`: AzureActiveDirectoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureActiveDirectory = mapped
    }

    /**
     * @param argument The AAD authentication settings of the cluster.
     */
    @JvmName("rppatupxiajcrfuv")
    public suspend
    fun azureActiveDirectory(argument: suspend AzureActiveDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureActiveDirectory = mapped
    }

    /**
     * @param value The port used for client connections to the cluster.
     */
    @JvmName("gccdkrfilvlfpcig")
    public suspend fun clientConnectionPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientConnectionPort = mapped
    }

    /**
     * @param value Client certificates that are allowed to manage the cluster.
     */
    @JvmName("iifxmpkhchxndtws")
    public suspend fun clients(`value`: List<ClientCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clients = mapped
    }

    /**
     * @param argument Client certificates that are allowed to manage the cluster.
     */
    @JvmName("qarfdxnmlikpnyhf")
    public suspend fun clients(argument: List<suspend ClientCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClientCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clients = mapped
    }

    /**
     * @param argument Client certificates that are allowed to manage the cluster.
     */
    @JvmName("bwessaaujqmywbau")
    public suspend fun clients(vararg argument: suspend ClientCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClientCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clients = mapped
    }

    /**
     * @param argument Client certificates that are allowed to manage the cluster.
     */
    @JvmName("cbdedtjdwjkxktxt")
    public suspend fun clients(argument: suspend ClientCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClientCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clients = mapped
    }

    /**
     * @param values Client certificates that are allowed to manage the cluster.
     */
    @JvmName("fujspcqgpolfevfo")
    public suspend fun clients(vararg values: ClientCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clients = mapped
    }

    /**
     * @param value The Service Fabric runtime version of the cluster. This property is required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
     */
    @JvmName("sckvaixooichxgmg")
    public suspend fun clusterCodeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterCodeVersion = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("yrlqnbhxrhgfgudr")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
     */
    @JvmName("agkqocrrmobfefom")
    public suspend fun clusterUpgradeCadence(`value`: Either<String, ClusterUpgradeCadence>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterUpgradeCadence = mapped
    }

    /**
     * @param value Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
     */
    @JvmName("bosdkqroowigwcxp")
    public fun clusterUpgradeCadence(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterUpgradeCadence>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUpgradeCadence = mapped
    }

    /**
     * @param value Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
     */
    @JvmName("tnnrkyycekreqnjf")
    public fun clusterUpgradeCadence(`value`: ClusterUpgradeCadence) {
        val toBeMapped = Either.ofRight<String, ClusterUpgradeCadence>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUpgradeCadence = mapped
    }

    /**
     * @param value The upgrade mode of the cluster when new Service Fabric runtime version is available.
     */
    @JvmName("bgowmgoviyrmbfap")
    public suspend fun clusterUpgradeMode(`value`: Either<String, ClusterUpgradeMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterUpgradeMode = mapped
    }

    /**
     * @param value The upgrade mode of the cluster when new Service Fabric runtime version is available.
     */
    @JvmName("ysakpkvncdjyxodw")
    public fun clusterUpgradeMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUpgradeMode = mapped
    }

    /**
     * @param value The upgrade mode of the cluster when new Service Fabric runtime version is available.
     */
    @JvmName("bafingfskrugbpet")
    public fun clusterUpgradeMode(`value`: ClusterUpgradeMode) {
        val toBeMapped = Either.ofRight<String, ClusterUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterUpgradeMode = mapped
    }

    /**
     * @param value The cluster dns name.
     */
    @JvmName("dvkysdxmfxeapkwu")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsName = mapped
    }

    /**
     * @param value Setting this to true enables automatic OS upgrade for the node types that are created using any platform OS image with version 'latest'. The default value for this setting is false.
     */
    @JvmName("rouqqqybugagoled")
    public suspend fun enableAutoOSUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoOSUpgrade = mapped
    }

    /**
     * @param value Setting this to true creates IPv6 address space for the default VNet used by the cluster. This setting cannot be changed once the cluster is created. The default value for this setting is false.
     */
    @JvmName("pppgibjcginkkgjt")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value Setting this to true will link the IPv4 address as the ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the cluster.
     */
    @JvmName("yfyddfvgooiplbof")
    public suspend fun enableServicePublicIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableServicePublicIP = mapped
    }

    /**
     * @param value The list of custom fabric settings to configure the cluster.
     */
    @JvmName("vumwkdspfaslvkwj")
    public suspend fun fabricSettings(`value`: List<SettingsSectionDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricSettings = mapped
    }

    /**
     * @param argument The list of custom fabric settings to configure the cluster.
     */
    @JvmName("nqovkkxqdcoajbjt")
    public suspend
    fun fabricSettings(argument: List<suspend SettingsSectionDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SettingsSectionDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fabricSettings = mapped
    }

    /**
     * @param argument The list of custom fabric settings to configure the cluster.
     */
    @JvmName("demmxlauvfixmjsg")
    public suspend fun fabricSettings(
        vararg
        argument: suspend SettingsSectionDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SettingsSectionDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fabricSettings = mapped
    }

    /**
     * @param argument The list of custom fabric settings to configure the cluster.
     */
    @JvmName("pusktflutbrjciqq")
    public suspend
    fun fabricSettings(argument: suspend SettingsSectionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SettingsSectionDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fabricSettings = mapped
    }

    /**
     * @param values The list of custom fabric settings to configure the cluster.
     */
    @JvmName("nrheryvdjgnkmdwx")
    public suspend fun fabricSettings(vararg values: SettingsSectionDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricSettings = mapped
    }

    /**
     * @param value The port used for HTTP connections to the cluster.
     */
    @JvmName("brkoelaxygmjvdna")
    public suspend fun httpGatewayConnectionPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGatewayConnectionPort = mapped
    }

    /**
     * @param value The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("pjghyjgwohiqodfv")
    public suspend fun ipTags(`value`: List<IPTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("oojlrxvvtbxgwomd")
    public suspend fun ipTags(argument: List<suspend IPTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("dfjwpxbkdrorhlwq")
    public suspend fun ipTags(vararg argument: suspend IPTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("rdgalojewprrrlkv")
    public suspend fun ipTags(argument: suspend IPTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of IP tags associated with the default public IP address of the cluster.
     */
    @JvmName("xixgrbwhgerjiqdy")
    public suspend fun ipTags(vararg values: IPTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("ocfqyqmbotkriskf")
    public suspend fun loadBalancingRules(`value`: List<LoadBalancingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("snsvqcdujfeudsqa")
    public suspend
    fun loadBalancingRules(argument: List<suspend LoadBalancingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("kbhbruguvolledgr")
    public suspend fun loadBalancingRules(
        vararg
        argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("vmtpyhjioeidqatj")
    public suspend fun loadBalancingRules(argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadBalancingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param values Load balancing rules that are applied to the public load balancer of the cluster.
     */
    @JvmName("lecubpsnqebrelut")
    public suspend fun loadBalancingRules(vararg values: LoadBalancingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param value Azure resource location.
     */
    @JvmName("dgdbettqawmpvbhs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("rjwskcojxqnnwxku")
    public suspend fun networkSecurityRules(`value`: List<NetworkSecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("kqvbmgvbfljybmmg")
    public suspend
    fun networkSecurityRules(argument: List<suspend NetworkSecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("wabaitbcghpwbejk")
    public suspend fun networkSecurityRules(
        vararg
        argument: suspend NetworkSecurityRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("habjjioqkiipyllw")
    public suspend
    fun networkSecurityRules(argument: suspend NetworkSecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkSecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param values Custom Network Security Rules that are applied to the Virtual Network of the cluster.
     */
    @JvmName("rnsccidvyhoitlis")
    public suspend fun networkSecurityRules(vararg values: NetworkSecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSecurityRules = mapped
    }

    /**
     * @param value Specify the resource id of a public IP prefix that the load balancer will allocate a public IP address from. Only supports IPv4.
     */
    @JvmName("fkqhejyovjgycpsq")
    public suspend fun publicIPPrefixId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefixId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lgmitdhncdimhrfj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Service endpoints for subnets in the cluster.
     */
    @JvmName("mrhqyxqwvyscojoa")
    public suspend fun serviceEndpoints(`value`: List<ServiceEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument Service endpoints for subnets in the cluster.
     */
    @JvmName("sjwcofrlxqgxwmmk")
    public suspend
    fun serviceEndpoints(argument: List<suspend ServiceEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument Service endpoints for subnets in the cluster.
     */
    @JvmName("ajfpfriwnlexmpux")
    public suspend fun serviceEndpoints(
        vararg
        argument: suspend ServiceEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument Service endpoints for subnets in the cluster.
     */
    @JvmName("yviendtbxebhtqgj")
    public suspend fun serviceEndpoints(argument: suspend ServiceEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param values Service endpoints for subnets in the cluster.
     */
    @JvmName("alyhrwhsyhdhchna")
    public suspend fun serviceEndpoints(vararg values: ServiceEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param value The sku of the managed cluster
     */
    @JvmName("ewbxgqafabsipgng")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of the managed cluster
     */
    @JvmName("sucrcykilggrmbtm")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value If specified, the node types for the cluster are created in this subnet instead of the default VNet. The **networkSecurityRules** specified for the cluster are also applied to this subnet. This setting cannot be changed once the cluster is created.
     */
    @JvmName("weksobmtigbfuodf")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("rxacaccwtphoqkpf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("scobqlqsmyeijrxp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value For new clusters, this parameter indicates that it uses Bring your own VNet, but the subnet is specified at node type level; and for such clusters, the subnetId property is required for node types.
     */
    @JvmName("fnmfhxwupaiwiree")
    public suspend fun useCustomVnet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCustomVnet = mapped
    }

    /**
     * @param value Indicates if the cluster has zone resiliency.
     */
    @JvmName("blshotleawjutwie")
    public suspend fun zonalResiliency(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zonalResiliency = mapped
    }

    /**
     * @param value Indicates the update mode for Cross Az clusters.
     */
    @JvmName("jmblwadmhaeyllih")
    public suspend fun zonalUpdateMode(`value`: Either<String, ZonalUpdateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zonalUpdateMode = mapped
    }

    /**
     * @param value Indicates the update mode for Cross Az clusters.
     */
    @JvmName("dgfbencdttbrobfm")
    public fun zonalUpdateMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZonalUpdateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zonalUpdateMode = mapped
    }

    /**
     * @param value Indicates the update mode for Cross Az clusters.
     */
    @JvmName("uoinktbrjolnpxyx")
    public fun zonalUpdateMode(`value`: ZonalUpdateMode) {
        val toBeMapped = Either.ofRight<String, ZonalUpdateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zonalUpdateMode = mapped
    }

    internal fun build(): ManagedClusterArgs = ManagedClusterArgs(
        addonFeatures = addonFeatures,
        adminPassword = adminPassword,
        adminUserName = adminUserName,
        allowRdpAccess = allowRdpAccess,
        applicationTypeVersionsCleanupPolicy = applicationTypeVersionsCleanupPolicy,
        auxiliarySubnets = auxiliarySubnets,
        azureActiveDirectory = azureActiveDirectory,
        clientConnectionPort = clientConnectionPort,
        clients = clients,
        clusterCodeVersion = clusterCodeVersion,
        clusterName = clusterName,
        clusterUpgradeCadence = clusterUpgradeCadence,
        clusterUpgradeMode = clusterUpgradeMode,
        dnsName = dnsName,
        enableAutoOSUpgrade = enableAutoOSUpgrade,
        enableIpv6 = enableIpv6,
        enableServicePublicIP = enableServicePublicIP,
        fabricSettings = fabricSettings,
        httpGatewayConnectionPort = httpGatewayConnectionPort,
        ipTags = ipTags,
        loadBalancingRules = loadBalancingRules,
        location = location,
        networkSecurityRules = networkSecurityRules,
        publicIPPrefixId = publicIPPrefixId,
        resourceGroupName = resourceGroupName,
        serviceEndpoints = serviceEndpoints,
        sku = sku,
        subnetId = subnetId,
        tags = tags,
        useCustomVnet = useCustomVnet,
        zonalResiliency = zonalResiliency,
        zonalUpdateMode = zonalUpdateMode,
    )
}
