@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getManagedClusterApplicationPlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getManagedClusterApplicationTypePlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getManagedClusterApplicationTypeVersionPlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getManagedClusterPlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getManagedClusterServicePlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getNodeTypePlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getmanagedAzResiliencyStatusPlain
import com.pulumi.azurenative.servicefabric.ServicefabricFunctions.getmanagedMaintenanceWindowStatusPlain
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationPlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationPlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationTypePlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationTypePlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationTypeVersionPlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterApplicationTypeVersionPlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterPlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterPlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterServicePlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetManagedClusterServicePlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetNodeTypePlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetNodeTypePlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetmanagedAzResiliencyStatusPlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetmanagedAzResiliencyStatusPlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetmanagedMaintenanceWindowStatusPlainArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.GetmanagedMaintenanceWindowStatusPlainArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationTypeResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationTypeVersionResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterServiceResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetNodeTypeResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetmanagedAzResiliencyStatusResult
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetmanagedMaintenanceWindowStatusResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationResult.Companion.toKotlin as getManagedClusterApplicationResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationTypeResult.Companion.toKotlin as getManagedClusterApplicationTypeResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterApplicationTypeVersionResult.Companion.toKotlin as getManagedClusterApplicationTypeVersionResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterResult.Companion.toKotlin as getManagedClusterResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetManagedClusterServiceResult.Companion.toKotlin as getManagedClusterServiceResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetNodeTypeResult.Companion.toKotlin as getNodeTypeResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetmanagedAzResiliencyStatusResult.Companion.toKotlin as getmanagedAzResiliencyStatusResultToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.GetmanagedMaintenanceWindowStatusResult.Companion.toKotlin as getmanagedMaintenanceWindowStatusResultToKotlin

public object ServicefabricFunctions {
    /**
     * Get a Service Fabric managed cluster resource created or in the process of being created in the specified resource group.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2020-01-01-preview, 2022-01-01, 2022-10-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The managed cluster resource
     */
    public suspend fun getManagedCluster(argument: GetManagedClusterPlainArgs):
        GetManagedClusterResult =
        getManagedClusterResultToKotlin(getManagedClusterPlain(argument.toJava()).await())

    /**
     * @see [getManagedCluster].
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @return The managed cluster resource
     */
    public suspend fun getManagedCluster(clusterName: String, resourceGroupName: String):
        GetManagedClusterResult {
        val argument = GetManagedClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedClusterResultToKotlin(getManagedClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetManagedClusterPlainArgs].
     * @return The managed cluster resource
     */
    public suspend
    fun getManagedCluster(argument: suspend GetManagedClusterPlainArgsBuilder.() -> Unit):
        GetManagedClusterResult {
        val builder = GetManagedClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterResultToKotlin(getManagedClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service Fabric managed application resource created or in the process of being created in the Service Fabric cluster resource.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The application resource.
     */
    public suspend fun getManagedClusterApplication(argument: GetManagedClusterApplicationPlainArgs):
        GetManagedClusterApplicationResult =
        getManagedClusterApplicationResultToKotlin(getManagedClusterApplicationPlain(argument.toJava()).await())

    /**
     * @see [getManagedClusterApplication].
     * @param applicationName The name of the application resource.
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @return The application resource.
     */
    public suspend fun getManagedClusterApplication(
        applicationName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetManagedClusterApplicationResult {
        val argument = GetManagedClusterApplicationPlainArgs(
            applicationName = applicationName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedClusterApplicationResultToKotlin(getManagedClusterApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedClusterApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetManagedClusterApplicationPlainArgs].
     * @return The application resource.
     */
    public suspend
    fun getManagedClusterApplication(argument: suspend GetManagedClusterApplicationPlainArgsBuilder.() -> Unit):
        GetManagedClusterApplicationResult {
        val builder = GetManagedClusterApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterApplicationResultToKotlin(getManagedClusterApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service Fabric application type name resource created or in the process of being created in the Service Fabric managed cluster resource.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The application type name resource
     */
    public suspend
    fun getManagedClusterApplicationType(argument: GetManagedClusterApplicationTypePlainArgs):
        GetManagedClusterApplicationTypeResult =
        getManagedClusterApplicationTypeResultToKotlin(getManagedClusterApplicationTypePlain(argument.toJava()).await())

    /**
     * @see [getManagedClusterApplicationType].
     * @param applicationTypeName The name of the application type name resource.
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @return The application type name resource
     */
    public suspend fun getManagedClusterApplicationType(
        applicationTypeName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetManagedClusterApplicationTypeResult {
        val argument = GetManagedClusterApplicationTypePlainArgs(
            applicationTypeName = applicationTypeName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedClusterApplicationTypeResultToKotlin(getManagedClusterApplicationTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedClusterApplicationType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetManagedClusterApplicationTypePlainArgs].
     * @return The application type name resource
     */
    public suspend
    fun getManagedClusterApplicationType(argument: suspend GetManagedClusterApplicationTypePlainArgsBuilder.() -> Unit):
        GetManagedClusterApplicationTypeResult {
        val builder = GetManagedClusterApplicationTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterApplicationTypeResultToKotlin(getManagedClusterApplicationTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service Fabric managed application type version resource created or in the process of being created in the Service Fabric managed application type name resource.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An application type version resource for the specified application type name resource.
     */
    public suspend
    fun getManagedClusterApplicationTypeVersion(argument: GetManagedClusterApplicationTypeVersionPlainArgs):
        GetManagedClusterApplicationTypeVersionResult =
        getManagedClusterApplicationTypeVersionResultToKotlin(getManagedClusterApplicationTypeVersionPlain(argument.toJava()).await())

    /**
     * @see [getManagedClusterApplicationTypeVersion].
     * @param applicationTypeName The name of the application type name resource.
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @param version The application type version.
     * @return An application type version resource for the specified application type name resource.
     */
    public suspend fun getManagedClusterApplicationTypeVersion(
        applicationTypeName: String,
        clusterName: String,
        resourceGroupName: String,
        version: String,
    ): GetManagedClusterApplicationTypeVersionResult {
        val argument = GetManagedClusterApplicationTypeVersionPlainArgs(
            applicationTypeName = applicationTypeName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getManagedClusterApplicationTypeVersionResultToKotlin(getManagedClusterApplicationTypeVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedClusterApplicationTypeVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetManagedClusterApplicationTypeVersionPlainArgs].
     * @return An application type version resource for the specified application type name resource.
     */
    public suspend
    fun getManagedClusterApplicationTypeVersion(argument: suspend GetManagedClusterApplicationTypeVersionPlainArgsBuilder.() -> Unit):
        GetManagedClusterApplicationTypeVersionResult {
        val builder = GetManagedClusterApplicationTypeVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterApplicationTypeVersionResultToKotlin(getManagedClusterApplicationTypeVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service Fabric service resource created or in the process of being created in the Service Fabric managed application resource.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The service resource.
     */
    public suspend fun getManagedClusterService(argument: GetManagedClusterServicePlainArgs):
        GetManagedClusterServiceResult =
        getManagedClusterServiceResultToKotlin(getManagedClusterServicePlain(argument.toJava()).await())

    /**
     * @see [getManagedClusterService].
     * @param applicationName The name of the application resource.
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the service resource in the format of {applicationName}~{serviceName}.
     * @return The service resource.
     */
    public suspend fun getManagedClusterService(
        applicationName: String,
        clusterName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetManagedClusterServiceResult {
        val argument = GetManagedClusterServicePlainArgs(
            applicationName = applicationName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getManagedClusterServiceResultToKotlin(getManagedClusterServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedClusterService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetManagedClusterServicePlainArgs].
     * @return The service resource.
     */
    public suspend
    fun getManagedClusterService(argument: suspend GetManagedClusterServicePlainArgsBuilder.() -> Unit):
        GetManagedClusterServiceResult {
        val builder = GetManagedClusterServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterServiceResultToKotlin(getManagedClusterServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service Fabric node type of a given managed cluster.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2021-09-01-privatepreview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
     */
    public suspend fun getNodeType(argument: GetNodeTypePlainArgs): GetNodeTypeResult =
        getNodeTypeResultToKotlin(getNodeTypePlain(argument.toJava()).await())

    /**
     * @see [getNodeType].
     * @param clusterName The name of the cluster resource.
     * @param nodeTypeName The name of the node type.
     * @param resourceGroupName The name of the resource group.
     * @return Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
     */
    public suspend fun getNodeType(
        clusterName: String,
        nodeTypeName: String,
        resourceGroupName: String,
    ): GetNodeTypeResult {
        val argument = GetNodeTypePlainArgs(
            clusterName = clusterName,
            nodeTypeName = nodeTypeName,
            resourceGroupName = resourceGroupName,
        )
        return getNodeTypeResultToKotlin(getNodeTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetNodeTypePlainArgs].
     * @return Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
     */
    public suspend fun getNodeType(argument: suspend GetNodeTypePlainArgsBuilder.() -> Unit):
        GetNodeTypeResult {
        val builder = GetNodeTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeTypeResultToKotlin(getNodeTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Action to get Az Resiliency Status of all the Base resources constituting Service Fabric Managed Clusters.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2022-10-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.
     */
    public suspend fun getmanagedAzResiliencyStatus(argument: GetmanagedAzResiliencyStatusPlainArgs):
        GetmanagedAzResiliencyStatusResult =
        getmanagedAzResiliencyStatusResultToKotlin(getmanagedAzResiliencyStatusPlain(argument.toJava()).await())

    /**
     * @see [getmanagedAzResiliencyStatus].
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @return Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.
     */
    public suspend fun getmanagedAzResiliencyStatus(clusterName: String, resourceGroupName: String):
        GetmanagedAzResiliencyStatusResult {
        val argument = GetmanagedAzResiliencyStatusPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getmanagedAzResiliencyStatusResultToKotlin(getmanagedAzResiliencyStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getmanagedAzResiliencyStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetmanagedAzResiliencyStatusPlainArgs].
     * @return Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.
     */
    public suspend
    fun getmanagedAzResiliencyStatus(argument: suspend GetmanagedAzResiliencyStatusPlainArgsBuilder.() -> Unit):
        GetmanagedAzResiliencyStatusResult {
        val builder = GetmanagedAzResiliencyStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getmanagedAzResiliencyStatusResultToKotlin(getmanagedAzResiliencyStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Action to get Maintenance Window Status of the Service Fabric Managed Clusters.
     * Azure REST API version: 2023-07-01-preview.
     * Other available API versions: 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Describes the maintenance window status of the Service Fabric Managed Cluster.
     */
    public suspend
    fun getmanagedMaintenanceWindowStatus(argument: GetmanagedMaintenanceWindowStatusPlainArgs):
        GetmanagedMaintenanceWindowStatusResult =
        getmanagedMaintenanceWindowStatusResultToKotlin(getmanagedMaintenanceWindowStatusPlain(argument.toJava()).await())

    /**
     * @see [getmanagedMaintenanceWindowStatus].
     * @param clusterName The name of the cluster resource.
     * @param resourceGroupName The name of the resource group.
     * @return Describes the maintenance window status of the Service Fabric Managed Cluster.
     */
    public suspend fun getmanagedMaintenanceWindowStatus(
        clusterName: String,
        resourceGroupName: String,
    ): GetmanagedMaintenanceWindowStatusResult {
        val argument = GetmanagedMaintenanceWindowStatusPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getmanagedMaintenanceWindowStatusResultToKotlin(getmanagedMaintenanceWindowStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getmanagedMaintenanceWindowStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabric&#46;kotlin&#46;inputs&#46;GetmanagedMaintenanceWindowStatusPlainArgs].
     * @return Describes the maintenance window status of the Service Fabric Managed Cluster.
     */
    public suspend
    fun getmanagedMaintenanceWindowStatus(argument: suspend GetmanagedMaintenanceWindowStatusPlainArgsBuilder.() -> Unit):
        GetmanagedMaintenanceWindowStatusResult {
        val builder = GetmanagedMaintenanceWindowStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getmanagedMaintenanceWindowStatusResultToKotlin(getmanagedMaintenanceWindowStatusPlain(builtArgument.toJava()).await())
    }
}
