@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
 */
public enum class FailureAction(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.FailureAction,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.FailureAction> {
    /**
     * Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade fails.
     */
    Rollback(com.pulumi.azurenative.servicefabric.enums.FailureAction.Rollback),

    /**
     * Indicates that a manual repair will need to be performed by the administrator if the upgrade fails. Service Fabric will not proceed to the next upgrade domain automatically.
     */
    Manual(com.pulumi.azurenative.servicefabric.enums.FailureAction.Manual),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.FailureAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.FailureAction):
            FailureAction = FailureAction.values().first { it.javaValue == javaType }
    }
}
