@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the move cost for the service.
 */
public enum class MoveCost(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.MoveCost,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.MoveCost> {
    /**
     * Zero move cost. This value is zero.
     */
    Zero(com.pulumi.azurenative.servicefabric.enums.MoveCost.Zero),

    /**
     * Specifies the move cost of the service as Low. The value is 1.
     */
    Low(com.pulumi.azurenative.servicefabric.enums.MoveCost.Low),

    /**
     * Specifies the move cost of the service as Medium. The value is 2.
     */
    Medium(com.pulumi.azurenative.servicefabric.enums.MoveCost.Medium),

    /**
     * Specifies the move cost of the service as High. The value is 3.
     */
    High(com.pulumi.azurenative.servicefabric.enums.MoveCost.High),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.MoveCost = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.MoveCost): MoveCost =
            MoveCost.values().first { it.javaValue == javaType }
    }
}
