@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The reference to the transport protocol used by the load balancing rule.
 */
public enum class Protocol(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.Protocol,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.Protocol> {
    Tcp(com.pulumi.azurenative.servicefabric.enums.Protocol.Tcp),
    Udp(com.pulumi.azurenative.servicefabric.enums.Protocol.Udp),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.Protocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.Protocol): Protocol =
            Protocol.values().first { it.javaValue == javaType }
    }
}
