@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * action to be performed on the vms before bootstrapping the service fabric runtime.
 */
public enum class VmSetupAction(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.VmSetupAction,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.VmSetupAction> {
    /**
     * Enable windows containers feature.
     */
    EnableContainers(com.pulumi.azurenative.servicefabric.enums.VmSetupAction.EnableContainers),

    /**
     * Enables windows HyperV feature.
     */
    EnableHyperV(com.pulumi.azurenative.servicefabric.enums.VmSetupAction.EnableHyperV),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.VmSetupAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.VmSetupAction):
            VmSetupAction = VmSetupAction.values().first { it.javaValue == javaType }
    }
}
